/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import java.util.*;
import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.launcher.*;
import org.eclipse.swt.widgets.*;

/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ExecutionTimeProfilingType implements IProfilingType {
	
	private ExecutionTimeUI _optionsUI;		//the UI asociated with this type
	private Control control;				//the control from the UI
	private boolean isInitialized = false;
	
	public ExecutionTimeProfilingType()
	{
		_optionsUI = new ExecutionTimeUI();
	}
	
	public Control createControl(Composite parent, ProfilingSetsManagerCopy config)
	{
		control =  _optionsUI.createControl(parent);
		initializeValues(config);
		
		return control;
	}
	
	protected void initializeValues(ProfilingSetsManagerCopy config)
	{
		Map configAttributes = config.getDefaultSet().getAttributes();
		//sets the attributes based on the config
		//if they haven't been stored yet, then use the default I specify
		String prefix = "SETOPTION_";		
		Object option = configAttributes.get(prefix+Options.OPTION_BOUNDARY_DEPTH);
		if(option == null)
		{
			_optionsUI.setCollectionDepth("1");			
		}
		else
		{
			_optionsUI.setCollectionDepth(((ProfilingAttribute)option).getValue());
			_optionsUI.setExecutionBoundary(true);
		}
		
		option = configAttributes.get(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW);
		if(option == null)
		{
			_optionsUI.setExecutionFlow(false);
			_optionsUI.setExecutionStatistic(!_optionsUI.getExecutionFlow());
			
		}
		else
		{
			_optionsUI.setExecutionFlow(((ProfilingAttribute)option).getValue().equalsIgnoreCase("true"));
			_optionsUI.setExecutionStatistic(!_optionsUI.getExecutionFlow());
			
		}
		
		option = configAttributes.get(prefix+Options.OPTION_TRACE_MODE);
		if(option != null)
		{
			String instanceValue = ((ProfilingAttribute)option).getValue();
			if(!instanceValue.equals(Options.OPTION_VALUE_NOOBJECTCORRELATION))
				_optionsUI.setInstance(true);			
		}
				
		_optionsUI.enableButtons();
				
		//storeValues();
	}
	
	
	public Control getControl(String profilingSetName)
	{
		return control;
	}
	
	public ProfilingAttribute[] getAttributes()
	{
		//map my UI options to options for the RAC
		//to be recognized as RAC options, the name should be prefixed by SETOPTION_
		String prefix = "SETOPTION_";		
		List options = new ArrayList();
		
		String[][] heap = Options.OPTIONS_ANALYZE_HEAP;		
		for (int idx = 0; idx < heap.length; idx++) {
			options.add(new ProfilingAttribute(prefix+heap[idx][0], heap[idx][1]));
		}			
						
		if (_optionsUI.getExecutionBoundary())
		{
			String[][] boundary = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
			for (int idx = 0; idx < boundary.length; idx++) {				
				options.add(new ProfilingAttribute(prefix+boundary[idx][0], boundary[idx][1]));
			}
			
			//add boundary depth
			options.add(new ProfilingAttribute(prefix+Options.OPTION_BOUNDARY_DEPTH, String.valueOf(_optionsUI.getCollectionDepth())));
		}
		else
		{
			String[][] flow = Options.OPTIONS_EXECUTION_FLOW;
			for (int idx = 0; idx < flow.length; idx++) {
				options.add(new ProfilingAttribute(prefix+flow[idx][0], flow[idx][1]));
				
			}		
		}

		String flow = String.valueOf(!_optionsUI.getExecutionStatistic()); 
		options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, flow));
		String showHeap = String.valueOf(_optionsUI.getInstance());
		options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_INSTANCES, showHeap));

		ProfilingAttribute[] pOptions = new ProfilingAttribute[options.size()];
		options.toArray(pOptions);
		return pOptions;
	}
	
	/**
	 * Returns a not null error message is the current configuration is not valid
	 * This method is called when the current configuration is updated, for example when
	 * the user updates the profiling options for the current filter set 
	 * performApply is called next if this method returns a null value for all selected 
	 * profiling types
	 * 
	 * @param managerCopy a temporary copy for the current configuration
	 * @return null if the configuration is valid and can be applied
	 */
	public String validateConfiguration(ProfilingSetsManagerCopy managerCopy)
	{
		return null;
	}

	/**
	 * This method is called from the launch configuration, prior to launching the application
	 * If the method returns a not null string, an error message will be displayed and the
	 * launch configuration aborts
	 * @param config
	 * @return
	 */	
	public String launch(ILaunchConfiguration config)
	{
		return null;
    }
	

}
