/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 *  Page 2 of the base resource import-from-zip Wizard.
 *  which specific the range of file to be imported.
 */

public class ImportTraceRange implements SelectionListener,ModifyListener {

	Label _regionLabel;
	Button _wholeFileBtn;
	Button _inRangeBtn;
	Label _startLabel;
	Text _startText;
	Label _ofFileLabel1;		
	Label _ofFileLabel2;
	Label _stopLabel;
	Text _stopText;
	double startValue	= 0.0;
	double stopValue	= 100.0;
	WizardPage _wizardPage;

public ImportTraceRange(WizardPage wp) {
	_wizardPage = wp;	
}

public void createControl(Composite parent) {
	GridLayout layout;
	
	Group composite = new Group(parent, SWT.NULL);
	composite.setLayout(new GridLayout());
	composite.setLayoutData(new GridData(
		GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
	composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	composite.setText(UIPlugin.getResourceString("IMPORT_OPTION_STR"));

	Composite optionGroup = new Composite(composite, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 7;
	layout.verticalSpacing=5;
	optionGroup.setLayout(layout);
	GridData gd = GridUtil.createFill();
	optionGroup.setLayoutData(gd);
	
	_wholeFileBtn = new Button(optionGroup, SWT.RADIO);
	gd = new GridData();
	gd.horizontalSpan = 7;
	_wholeFileBtn.setLayoutData(gd);
	_wholeFileBtn.setText(UIPlugin.getResourceString("IMPORT_COMPLETE_STR"));
	
	_inRangeBtn = new Button(optionGroup, SWT.RADIO);
	_inRangeBtn.setText(UIPlugin.getResourceString("IMPORT_PARTIAL_STR"));
	
	_startLabel = new Label(optionGroup, SWT.NONE);
	_startLabel.setText(UIPlugin.getResourceString("FROM_STR"));
	
	_startText = new Text(optionGroup, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 30;
	_startText.setLayoutData(gd);
	
	_ofFileLabel1 = new Label(optionGroup, SWT.NONE);
	_ofFileLabel1.setText(UIPlugin.getResourceString("PERCENT_OF_FILE_STR"));
	
	_stopLabel = new Label(optionGroup, SWT.NONE);
	_stopLabel.setText(UIPlugin.getResourceString("TO_STR"));

	_stopText = new Text(optionGroup, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 30;
	_stopText.setLayoutData(gd);	
	
	_ofFileLabel2 = new Label(optionGroup, SWT.NONE);
	_ofFileLabel2.setText(UIPlugin.getResourceString("PERCENT_OF_FILE_STR"));	

	_wholeFileBtn.addSelectionListener(this);
	_inRangeBtn.addSelectionListener(this);
	_startText.addModifyListener(this);
	_stopText.addModifyListener(this);

	initData();
}

private void initData()
{
	_wholeFileBtn.setSelection(true);
	_startText.setText(String.valueOf(startValue));
	_stopText.setText(String.valueOf(stopValue));
	setRangeInputEnable(false);	
}

public Button getWholeFileBtn()
{
	return _wholeFileBtn;
}
public Button getInRangeBtn()
{
	return _inRangeBtn;
}
public boolean getWholeFileSelection()
{
	return _wholeFileBtn.getSelection();
}
public boolean getInRangeSelection()
{
	return _inRangeBtn.getSelection();
}
public double getStartRange()
{
	return startValue;
}
public double getStopRange()
{
	return stopValue;
}
public String checkRegionValue()
{
	if (_startText.getText().trim().equals("") || _stopText.getText().trim().equals(""))
			return UIPlugin.getResourceString("CANNOT_EMPTY_VALUE");
		else
		{
			try 
			{
				startValue = Double.parseDouble(_startText.getText().trim());
				stopValue = Double.parseDouble(_stopText.getText().trim());
				if (startValue > stopValue)
					return UIPlugin.getResourceString("START_LARGER_STOP");
				else if (startValue == stopValue)
					return UIPlugin.getResourceString("CANNOT_SAME");
				else if (startValue <0 || startValue >100 || stopValue<0 || stopValue >100)
					return UIPlugin.getResourceString("INVALID_IMPORT_RANGE");
				else 
				{
					return null;
				}
			}
			catch (NumberFormatException nfe)
			{
				return UIPlugin.getResourceString("INVALID_IMPORT_STR");
			}
		}
}

public void modifyText(ModifyEvent e)
{
	if (e.widget == _startText || e.widget == _stopText)
			_wizardPage.setErrorMessage(checkRegionValue());
}


public void setRangeInputEnable(boolean enable)
{

	_startLabel.setEnabled(enable);
	_startText.setEnabled(enable);
	_ofFileLabel1.setEnabled(enable);
	_stopLabel.setEnabled(enable);
	_stopText.setEnabled(enable);
	_ofFileLabel2.setEnabled(enable);
}

public void widgetSelected(SelectionEvent e)
{
	if (e.widget == _wholeFileBtn)
	{
		setRangeInputEnable(false);
		startValue =0;
		stopValue = 100;
		_wizardPage.setErrorMessage(null);
		
	}
	else if (e.widget == _inRangeBtn)
	{
		setRangeInputEnable(true);
		_wizardPage.setErrorMessage(checkRegionValue());
		
	}
}

public void widgetDefaultSelected(SelectionEvent e) {}

}
