/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.launcher;

import org.eclipse.jface.resource.ImageDescriptor;
/**
 * Profiling Set Type Group interface
 * A profiling type group
 * (ie. Memory Analysis, Time Analysis, Memory Leak Analysis, Code Coverage..)
 */
public interface IProfilingSetTypeGroup {
	
	/**
	 * @return Returns the icon.
	 */
	public ImageDescriptor getIcon();
	
	/**
	 * @param icon The icon to set.
	 */
	public void setIcon(ImageDescriptor icon);
	
	/**
	 * @return Returns the id.
	 */
	public String getId();
	
	/**
	 * @param id The id to set.
	 */
	public void setId(String id);
	
	/**
	 * @return Returns the name.
	 */
	public String getName();
	
	/**
	 * @param name The name to set.
	 */
	public void setName(String name);	
}
