/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.*;

/**
 * @author znensi
 * Profiling Type interface
 */
public interface IProfilingType {
	
	/**
	 *  returns the control of the UI 
	 * @param parent 
	 * @param config - the ILaunchConfiguration where the attributes are stored
	 *	read the defaults from the UI from this config via the getAttribute method
	 * @return
	 */
	public Control createControl(Composite parent, ProfilingSetsManagerCopy config);
	
	/**
	 * 
	 * @param profilingSetName
	 * @return returns the control associated with this default
	 * profilingSetName is the profilingSet associated with this profilingType
	 * similar to it's parent
	 */
	public Control getControl(String profilingSetName);
	
	/**
	 * This method is called when the current configuration has been modified
	 * This can happen when the profiling types edit dialog is finished
	 * @return the list of configuration attributes set by this page
	 * For RAC options, the ProfilingAttribute name should be prefixed by SETOPTION_
	 * For RAC filters, the ProfilingAttribute name should be prefixed by SETFILTER_ 
	 */
	public ProfilingAttribute[] getAttributes();
	
	/**
	 * Returns a not null error message is the current configuration is not valid
	 * This method is called when the current configuration is updated, for example when
	 * the user updates the profiling options for the current filter set 
	 * performApply is called next if this method returns a null value for all selected 
	 * profiling types
	 * 
	 * @param managerCopy a temporary copy for the current configuration
	 * @return null if the configuration is valid and can be applied
	 */
	public String validateConfiguration(ProfilingSetsManagerCopy managerCopy);
	
	/**
	 * This method is called from the launch configuration, prior to launching the application
	 * If the method returns a not null string, an error message will be displayed and the
	 * launch configuration action is cancelled
	 * @param config
	 * @return an error message or null if the action is succesful
	 */
	public String launch(ILaunchConfiguration config);

}
