/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.util.ContextIds;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class EditColumnAction extends SelectionProviderAction {
	private DatapoolTable table;

	public EditColumnAction(ISelectionProvider viewer, DatapoolTable table)
	{
		super(viewer, DatapoolPlugin.getResourceString("EDIT_COL_TEXT"));
		setDescription(DatapoolPlugin.getResourceString("EDIT_COL_LDESC"));
		WorkbenchHelp.setHelp(this, DatapoolPlugin.getID() + ContextIds.EDIT_COL_ACT);
		this.table = table;
	}

	public void run()
	{
		if (table != null)
			table.editColumn();
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}
	
}
