
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// EObject -> INavigatorItem
public class SampleItemRegistry {
	private static final Map _map = new HashMap();
	
	public static final void addChild(Object obj, SampleItem item) {
		List children = (List)_map.get(obj);
		if (children == null) {
			children = new ArrayList();
			_map.put(obj, children);
		}
		children.add(item);
	}
	
	public static final void removeChild(Object obj, SampleItem item) {
		List children = (List)_map.get(obj);
		if (children != null)
			children.remove(item);
	}
	
	public static final boolean hasChildren(Object obj) {
		List children = (List)_map.get(obj);
		return (children != null && !children.isEmpty());
	}

	public static final List getChildren(Object obj) {
		List children = (List)_map.get(obj);
		if (children == null)
			return new ArrayList(0);
		return children;
	}
}
