/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.extractors;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.util.Messages;

/**
 * @author rduggan
 *
 */
public class RegularExpressionExtractor extends SimpleExtractor {
	
	private Perl5Compiler compiler = new Perl5Compiler();
	private PatternMatcherInput input = new PatternMatcherInput("");
	private Perl5Matcher matcher = new Perl5Matcher();

	private Pattern compiledStartPattern;
	private Pattern compiledEndPattern;
	
	public void update() throws AdapterInvalidConfig {
		super.update();
	
		/* If we have a start pattern then compile it now */
		if(getStartPattern()!=null && !getStartPattern().equals("")) {
			try {
				compiledStartPattern = compiler.compile(getStartPattern());
			}
			catch (MalformedPatternException e) {
				throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_Start_Pattern_Invalid",e.getMessage()));
			}
		}
	
		/* If we have a end pattern then compile it now */
		if(getEndPattern()!=null && !getEndPattern().equals("")) {
			try {
				compiledEndPattern = compiler.compile(getEndPattern());
			}
			catch (MalformedPatternException e) {
				/* RKD:  TODO Indicate the end pattern is bad regular expression */
				throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_End_Pattern_Invalid",e.getMessage()));
			}
		}
	}
	
	/**
	 * Search for the pattern in the specified search string.  If the pattern is located in the 
	 * search string then the position variable is loaded with the start of the pattern and the 
	 * end of the pattern.
	 * 
	 * @param pos
	 * @param pattern
	 * @param searchString
	 * @param startOffset
	 */
	protected void search(StringPosition position, String pattern, String searchString, int startOffset) {
		boolean found = false;
		String temp = null;
		int foundPosition = -1;
		
		Pattern expression=null;
		
		/* Which pattern are we searhing for */
		if(pattern==getStartPattern()) {
			expression=compiledStartPattern;
		}
		else {
			expression=compiledEndPattern;
		}
		input.setInput(searchString,startOffset, searchString.length() - startOffset);
		matcher.setMultiline(true);
		found = matcher.contains(input, expression);
		if (found) {
			temp = input.match();
			foundPosition = input.getMatchBeginOffset();
		}
		if (foundPosition > -1 && foundPosition<searchString.length()) {
			position.setStartPosition(foundPosition);
			/* For special characters such as '^' the start pattern may have length 0 */
			if(temp.length()>1) {
				position.setEndPosition(foundPosition+temp.length()-1);
			}
			else {
				position.setEndPosition(foundPosition);
			}
			position.setValid(true);
		}
	}

}
