/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.events.*;
/**
 * Abstract class provided for the convinience. Contains some default 
 * implementations of the main functionality for the component
 * Role of the abstract class Component is to provide initial most common 
 * implementation of  basic functionality for 
 * component.  So the class provide implementation for the getter
 * and setter for the componentName, getter and setter 
 * for the targetName, stabs for the start, stop and update functions.
 * @version 0.10
 */
public class Component implements IComponent
{
	protected AdapterSensor logger = null;
	private short loggingLevel = AdapterSensor.FINEST_LEVEL;
	private String name = null;
	private String role = null;
	private String executableClassName = null;
	private String description = null;
	private String uniqueID = null;
	// Version info
	private String roleVersion = null;
	private String implVersion = null;
	private String roleVersionDescription = null;
	private String implVersionDescription = null;
	private String roleCreationDate = null;
	private String implCreationDate = null;
	private IComponent[] components = null;
	private ISimpleEventFactory eventFactory = null;
	private IComponentIdentification sourceComponentId = null;
	/*
	 * indicates if context is stopping
	 */
	protected boolean stopping = false;
	/**
	 * contains config document fragment as a string 
	 */
	private Element configuration = null;
	/**
	 * contains context config document fragment as a string 
	 */
	private Element contextConfiguration = null;
	private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
	/**
	 * Constructor for Component.
	 */
	public Component()
	{
		super();
		sourceComponentId = getEventFactory().createComponentIdentification();
		sourceComponentId.setComponent(getName());
		sourceComponentId.setSubComponent(getUniqueID());
		sourceComponentId.setComponentIdType(getRole());
		sourceComponentId.setLocation("Test Source Component Location");
		sourceComponentId.setLocationType("Test Source Component Location Type");
	}
	/**
	 * Initialize all the Component level properties from the context config for this
	 * component, and then ask all child components to do the same.
	 * @see com.ibm.acad.general.common.IComponent#init()
	 */
	public boolean init()
	{
		Element element = getContextConfiguration();
		// 
		if (element.hasAttribute(Messages.getString("HyadesGADescriptionAttributeName")))
			setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGARoleAttributeName")))
			setRole(element.getAttribute(Messages.getString("HyadesGARoleAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGALoggingLevelAttributeName")))
			setLoggingLevel(
				Short
					.valueOf((element.getAttribute(Messages.getString("HyadesGALoggingLevelAttributeName"))))
					.shortValue());
		// set the version info if provided
		if (element.hasAttribute(Messages.getString("HyadesGARoleVersionAttributeName")))
			setRoleVersion(element.getAttribute(Messages.getString("HyadesGARoleVersionAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName")))
			setRoleCreationDate(element.getAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName")))
			setRoleVersionDescription(
				element.getAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName")))
			setImplementationVersion(
				element.getAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName")))
			setImplemenationCreationDate(
				element.getAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName")))
			setImplementationVersionDescription(
				element.getAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName")));
		IComponent[] components = getComponents();
		if (components != null)
			for (int i = 0; i < components.length; i++)
				components[i].init();
		sourceComponentId.setComponent(getName());
		sourceComponentId.setSubComponent(getUniqueID());
		sourceComponentId.setComponentIdType(getRole());
		//TODO: HS resolve what value to use for Location information
		sourceComponentId.setLocation("Test Source Component Location");
		sourceComponentId.setLocationType("Test Source Component Location Type");
		return true;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#start()
	 */
	public void start()
	{
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#stop(int)
	 */
	public void stop(int toStop)
	{
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#stop()
	 */
	public void stop()
	{
		//TODO: HS fully implement Component stop() method
		stopping = true;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#update(Element)
	 */
	public void update(Element config) throws AdapterInvalidConfig
	{
		setConfiguration(config);
		update();
	}
	/**
	 * Set Component instance level properties based on the component configuration Element.
	 * @see org.eclipse.hyades.logging.adapter.IComponent#update()
	 */
	public void update() throws AdapterInvalidConfig
	{
		Element element = getConfiguration();
		setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
		setUniqueID(element.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")));
		IComponent[] components = getComponents();
		if (components != null)
			for (int i = 0; i < components.length; i++)
				components[i].update();
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getContextConfiguration()
	 */
	public Element getContextConfiguration()
	{
		return contextConfiguration;
	}
	/**
	 * Sets the context config.
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setContextConfiguration(Element)
	 * @param config The configuration to set
	 */
	public void setContextConfiguration(Element newConfiguration)
	{
		contextConfiguration = newConfiguration;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getConfiguration()
	 */
	public Element getConfiguration()
	{
		return configuration;
	}
	/**
	 * Sets the config.
	 * @param config The configuration to set
	 */
	public void setConfiguration(Element newConfiguration)
	{
		configuration = newConfiguration;
	}
	// getters and setters for private members
	/**
	 * 
	 */
	public AdapterSensor getLogger()
	{
		if (logger == null)
			logger = AdapterSensor.getInstance();
		return logger;
	}
	public ISimpleEventFactory getEventFactory()
	{
		if (eventFactory == null)
			eventFactory = SimpleEventFactoryImpl.getInstance();
		return eventFactory;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getName()
	 */
	public short getLoggingLevel()
	{
		return loggingLevel;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setName(short)
	 */
	public void setLoggingLevel(short newLevel)
	{
		loggingLevel = newLevel;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getName()
	 */
	public String getName()
	{
		return name;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setName(java.lang.String)
	 */
	public void setName(String newName)
	{
		name = newName;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getRole()
	 */
	public String getRole()
	{
		return role;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setRole(java.lang.String)
	 */
	public void setRole(String newRole)
	{
		role = newRole;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setDescription(java.lang.String)
	 */
	public void setDescription(String newDescription)
	{
		description = newDescription;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getUniqueID()
	 */
	public String getUniqueID()
	{
		return uniqueID;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setUniqueID(java.lang.String)
	 */
	public void setUniqueID(String newUniqueID)
	{
		uniqueID = newUniqueID;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getExecutableClassName()
	 */
	public String getExecutableClassName()
	{
		return executableClassName;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setExecutableClassName(java.lang.String)
	 */
	public void setExecutableClassName(String newExecutableClassName)
	{
		executableClassName = newExecutableClassName;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getRoleVersion()
	 */
	public String getRoleVersion()
	{
		return roleVersion;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setRoleVersion(java.lang.String)
	 */
	public void setRoleVersion(String newRoleVersion)
	{
		roleVersion = newRoleVersion;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getRoleCreationDate()
	 */
	public String getRoleCreationDate()
	{
		return roleCreationDate;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setRoleCreationDate(java.lang.String)
	 */
	public void setRoleCreationDate(String newCreationDate)
	{
		roleCreationDate = newCreationDate;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getRoleVersionDescription()
	 */
	public String getRoleVersionDescription()
	{
		return roleVersionDescription;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setRoleVersionDescription(java.lang.String)
	 */
	public void setRoleVersionDescription(String newRoleVersionDescription)
	{
		roleVersionDescription = newRoleVersionDescription;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getImplementationVersion()
	 */
	public String getImplementationVersion()
	{
		return implVersion;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setImplementationVersion(java.lang.String)
	 */
	public void setImplementationVersion(String newImplementationVersion)
	{
		implVersion = newImplementationVersion;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getImplementationCreationDate()
	 */
	public String getImplementationCreationDate()
	{
		return implCreationDate;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setImplemenationCreationDate(java.lang.String)
	 */
	public void setImplemenationCreationDate(String newImplementationCreationDate)
	{
		implCreationDate = newImplementationCreationDate;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getImplementationVersionDescription()
	 */
	public String getImplementationVersionDescription()
	{
		return implVersionDescription;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setImplementationVersionDescription(java.lang.String)
	 */
	public void setImplementationVersionDescription(String newImplementationVersionDescription)
	{
		implVersionDescription = newImplementationVersionDescription;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#getComponents()
	 */
	public IComponent[] getComponents()
	{
		return components;
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.IComponent#setComponents(org.eclipse.hyades.logging.adapter.IComponent[])
	 */
	public void setComponents(IComponent[] newComponents)
	{
		components = newComponents;
	}
	public void clean()
	{
		for (int i = 0; i < components.length; i++)
		{
			components[i] = null;
		}
		components = null;
	}
	public void log(String text, short severity)
	{
		if (severity <= loggingLevel)
		{
			ICommonBaseEvent cbe = getEventFactory().createCommonBaseEvent();
			cbe.setSourceComponentId(sourceComponentId);
			cbe.setCreationTime(System.currentTimeMillis());
			cbe.setSeverity((severity));
			cbe.setMsg(text);
			getLogger().addEvent(cbe);
		}
	}
}
