/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.w3c.dom.Element;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.adapter.*;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
/**
 * Context is a component. A Context instance corresponds to one thread of processing - 
 * sensor, event extractor, parser, outputters etc. 
 * @version 0.10
 */
public abstract class Context extends Component implements IContext
{
	private boolean continuousOperation = false;
	private long maximumIdleTime = 0;
	private long pauseInterval = 0;
	private long pauseCount = 0;
	
	private boolean hardStop=false;
	
	protected IContextListener listener;
	
	public void stop() {
		super.stop();
		listener=null;
	}
	
	public void resetControledStop()
	{
		resetPauseCount();
	}
	public void resetPauseCount()
	{
		pauseCount = 0;
	}
	public void incrementPauseCount()
	{
		pauseCount++;
	}
	public long getPauseCount()
	{
		return pauseCount;
	}
	public void setPauseCount(long newPauseCount)
	{
		pauseCount = newPauseCount;
	}
	public void setContinuousOperation(boolean newContinuousOperation)
	{
		continuousOperation = newContinuousOperation;
	}
	public boolean getContinuousOperation()
	{
		return continuousOperation;
	}
	public void setMaximumIdleTime(long newMaximumIdleTime)
	{
		maximumIdleTime = newMaximumIdleTime;
	}
	public long getMaximumIdleTime()
	{
		return maximumIdleTime;
	}
	public void setPauseInterval(long newPauseInterval)
	{
		pauseInterval = newPauseInterval;
	}
	public long getPauseInterval()
	{
		return pauseInterval;
	}
	public void update() throws AdapterInvalidConfig
	{
		//TODO: HS handle exceptions
		Element element = getConfiguration();
		if (element.hasAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName")))
			setContinuousOperation(
				Boolean
					.valueOf(element.getAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName")))
					.booleanValue());
		if (element.hasAttribute(Messages.getString("HyadesGApauseIntervalAttributeName")))
			setPauseInterval(
				Long
					.valueOf(element.getAttribute(Messages.getString("HyadesGApauseIntervalAttributeName")))
					.longValue());
		if (element.hasAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName")))
			setMaximumIdleTime(
				Long
					.valueOf(element.getAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName")))
					.longValue());		
		super.update();
		return;
	}
	
	public void handleControledStop()
	{
		//if this is not a continuous run then stop right now
		if (!getContinuousOperation())
		{
			hardStop=false;
			stop();
		}
		else
		{
			//for a continuous operation, pause and keep track of the total paused time
			if (getMaximumIdleTime() / getPauseInterval() >= getPauseCount())
			{
				try
				{
					synchronized (this)
					{
						Thread.sleep(getPauseInterval());
					}
				}
				catch (Exception e)
				{
				}
				incrementPauseCount();
			}
			else
			{
				hardStop=true;
				stop();
			}
		}
	}
	
	/**
	 * @see org.eclipse.hyades.logging.adapter.IContext#setContextListener(IContextListener)
	 */
	public void setContextListener(IContextListener listener) {
		this.listener=listener;
	}
	
	/**
	 * @see org.eclipse.hyades.logging.adapter.IContext#getContextListener()
	 */
	public IContextListener getContextListener() {
		return listener;
	}
	
	/**
	 * 
	 */
	protected boolean isHardStop() {
		return hardStop;
	}
	/**
	 * Set the hardStop flag.
	 */
	protected void setHardStop() {
		hardStop = true;
		return; 
	}
}
