/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.impl;

import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

import org.eclipse.hyades.logging.adapter.IDirectedGraph;

/**
 * @author smith
 *
 * Implementation of IDirectedGraph using a vector for the path
 */
public class DirectedGraphImpl implements IDirectedGraph {

	private Vector _path=new Vector();
	private String _value=null;
	

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#getPath()
	 */
	public List getPath() {
		return _path;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#setPath(java.util.List)
	 */
	public void setPath(List path) {
		ListIterator li = path.listIterator();
		while (li.hasNext())
			_path.add(li.next());

	}
	
	/**
	 * Set the path based on an array of ints
	 * @param pth - int array
	 */

	public void setPath(int[] pth) {
		for (int i=0; i < pth.length; i++) {
			_path.add(new Integer(pth[i]));
		}
	}


	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#getValue()
	 */
	public Object getValue() {
		return _value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.IDirectedGraph#setValue(java.lang.Object)
	 */
	public void setValue(Object value) {
		if (value instanceof String) {
			_value = (String)value;
		}
		else {
			// TODO handle error case - not a String
		}
	}

}
