/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.internal.util;
/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/**
 * <p>Title: Paths.java</p>
 * <p>Description: Class responsible for resolving paths
 * </p>
 * @version 0.1
 **/
public final class Paths
{
	private static final String config = "test/configurations/";
	private static String path = null;
	private static String configPath = null;
	static {
		path =
			Paths
				.class
				.getClassLoader()
				.getResource("org/eclipse/hyades/logging/adapter/internal/util/Paths.class")
				.getPath();
		for (int ind = path.indexOf("%20"); ind > -1; ind = path.indexOf("%20", ind + 1))
		{
			path = path.substring(0, ind) + " " + path.substring(ind + 3, path.length());
		}
		//path=path.replaceAll("%20"," ");
		if (path.indexOf("file:") == 0)
		{
			path = path.substring(5);
		}
		if (path.charAt(0) == '/')
		{
			path = path.substring(1);
		}
		if (path.indexOf(".jar!") >= 0)
		{
			path =
				path.substring(0, path.indexOf(".jar!/org/eclipse/hyades/logging/adapter/internal/util/Paths.class"));
			path = path.substring(0, path.lastIndexOf("/") + 1);
		}
		else
		{
			path = path.substring(0, path.indexOf("org/eclipse/hyades/logging/adapter/internal/util/Paths.class"));
		}
		//check directories and recreate them if needed
		if (!path.startsWith("/") && (path.indexOf(":") < 0 || path.indexOf(":") > path.indexOf("/")))
		{
			path = "/" + path;
		}
		//TODO: handle a bin directory restriction
		//   	remove bin from path to allow workbench config to work

		if (path.endsWith("/bin/"))
			path = path.substring(0, path.lastIndexOf("/bin/") + 1);
		configPath = path + config;

	}
	/**
	 * private constructor so the class can not be instantiated
	 */
	private Paths()
	{
	}
	/**
	 * Returns the configPath.
	 * @return String
	 */
	public static String getConfigPath()
	{
		return configPath;
	}
	public static String getConfigFileName(String fileName)
	{
		if (!isDirectory(fileName))
			return getConfigPath() + fileName;
		else
			return fileName;
	}
	private static boolean isDirectory(String fileName)
	{
		if (fileName == null)
			return false;
		if (fileName.indexOf("\\") >= 0 || fileName.indexOf("/") >= 0)
			return true;
		return false;
	}
}
