package org.eclipse.hyades.logging.adapter.outputters;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

/**
 * CBEEclipseErrorDialogOutputter is an outputter that takes the given CBEs and
 * outputs them to an Eclipse error dialog.
 * 
 * @author Paul E. Slauenwhite
 */
public class CBEEclipseErrorDialogOutputter extends ProcessUnit implements IOutputter {

    public Object[] processEventItems(Object[] msgs) {

        if (msgs == null) {
            return msgs;
        }

        return processCBEs((ICommonBaseEvent[]) msgs);
    }

    private ICommonBaseEvent[] processCBEs(ICommonBaseEvent[] events) {

        short currentLoggingLevel = getLoggingLevel();

        for (int i = 0; i < events.length; i++) {

            short severity = events[i].getSeverity();

            /* if we are logging greater then our set logging level BUT NOT a tracing level then we will send this error to a dialog box.  Otherwise add it to the tasks list */
            if ((events[i] != null) && ((severity >= currentLoggingLevel) && (severity < AdapterSensor.TRACE_LEVEL))) {

                final ICommonBaseEvent event = events[i];

                Display.getDefault().syncExec(new Runnable() {

                    public void run() {
                        MessageDialog.openError(Display.getDefault().getActiveShell(), "Error", event.getMsg());
                    }
                });
            }
        }

        return events;
    }

    public Object[] testEventInterface(Object[] msgs) throws AdapterInvalidConfig {
        return testProcessCBEs((ICommonBaseEvent[]) msgs);
    }

    private ICommonBaseEvent[] testProcessCBEs(ICommonBaseEvent[] events) {
        return events;
    }
}
