package org.eclipse.hyades.logging.adapter.util;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.hyades.logging.adapter.AdapterException;

/**
 * @author GG
 * @version 0.95
 */
public class TimeParser
{

  // contains current format 
  private String format = null;
  // contains current formatter
  private SimpleDateFormat formatter = null;

  //set proper current format and all internal variables
  //for the formatting
  private void setFormat(String _format) throws AdapterException
  {
    if (_format!=null && !_format.equals(format))
	{
    	format = _format.trim();
    	try {
    		formatter = new SimpleDateFormat(format);
    	}
    	catch (IllegalArgumentException e) {
    		// Looks like we have an invalid format specifier - throw an exception
    		throw new AdapterException(e);
    	}
	}
    //To do check pattern
  }

  //public constructor
  public TimeParser(String timeFormat) throws AdapterException
  {
	setFormat(timeFormat);
  }
  
  /**
   * Converts the formatted time string to milliseconds
   * @param strTime
   * @return value of time in milliseconds as a long
   */
  public long parse(String strTime) throws AdapterException
  {
    long ret = 0;
    try
    {
      if (formatter!= null && format != null)
      {
		Date dt = formatter.parse(strTime.trim());
		if (dt != null)
		{
		  ret = dt.getTime();
		}
      }
    }
    catch (Exception ex)
    {
    	throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_TimeParser_Exception_Error", strTime.trim(), format), ex);
    }
    return ret;
  }
	
}