/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.views.adapter.internal.StatisticalViewerPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatisticalViewerUI extends StatisticalModelGraphViewer {

	protected StatisticalViewerPage _page;

	public StatisticalViewerUI(
		Composite parent,
		int style,
		boolean tabfolder, StatisticalViewerPage page
		, Dirtiable d,  URI current_project) {
		
		this(parent, style, tabfolder, d, current_project);
		
		_page = page;
	}

	public StatisticalViewerUI(
		Composite parent,
		int style,
		boolean tabfolder, StatisticalViewerPage page) {
			
	   this(parent, style, tabfolder);
					
		_page = page;
		
	}


	public StatisticalViewerUI(Composite parent, int style, boolean tabfolder) {		
		super(parent, style, tabfolder);
	}
	
	public StatisticalViewerUI(Composite parent, int style, boolean tabfolder, Dirtiable d,  URI current_project) {		

		super(parent, style, tabfolder, d,  current_project);

	}
	
	public void updateUI()
	{
	}
    
	public Control getControl()
	{
		return sashfolder;
	}
    
	public void selectionChanged()
	{
		if (sashfolder != null && !sashfolder.isDisposed() && sashfolder.isVisible() && !sashfolder.isFocusControl()) {
			//update viewer selection using common selection model
			//do nothing    	
		}
    	
	}
    
	public void refresh()
	{
		if (sashfolder != null && !sashfolder.isDisposed() && sashfolder.isVisible() && !sashfolder.isFocusControl()) {
			
			initialize();	
		}
		
	}

	public void initialize()
	{
		resetValues();
    	
		Object object = HyadesUtil.getMofObject();
		if(object == null || !(object instanceof EObject))
		  return;
		  
		getSDDescriptors((EObject)object);  
	}

	protected void resetValues()
	{
	  if(reverse_map != null)
		reverse_map.clear();
	  if(graph_map != null)
		graph_map.clear();
	  if(sddescriptor_map != null)
		  sddescriptor_map.clear();
    	
	  if(chooser_tree != null)
		  chooser_tree.removeAll();
	  if(bar_map != null)
		bar_map.clear();
	  if(bar_slider_map != null)
		bar_slider_map.clear();
	  if(counter_map != null)
		counter_map.clear();
	  if(modifiable_map != null)
		modifiable_map.clear();     
	  if(source_map != null)
		source_map.clear();   	
    	
	  if(graph_window != null)
		  graph_window.removeAllGraphs();
	  next = 0;
	  prev_used = 0;	
	  
	  if(disposables != null)
	    disposables.clear();
	  if(modules != null)
	    modules.clear();
	      
	  model_change_listeners.clear();
	  agent_change_listeners.clear();
	  node_change_listeners.clear();
	  
	  if(trcagent_map != null)
	    trcagent_map.clear();
	  if(msglist_map != null)
	    msglist_map.clear();
	    
	   if(agents != null)
	     agents.clear();  	        
	}
	
	protected  void getSDDescriptors(EObject mofObject)
	{
	  if (mofObject != null) {
		  if (mofObject instanceof TRCAgentProxy) {
			  if (((TRCAgentProxy) mofObject).getAgent() != null) {
			  	
				  addAgent(((TRCAgentProxy) mofObject).getAgent());
			  }
		  } else if (mofObject instanceof TRCProcessProxy) {
			  Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

			  for (int idx = 0; idx < agents.length; idx++) {
				  if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
				  	
					addAgent(((TRCAgentProxy) agents[idx]).getAgent());
				  	
				  }
			  }
		  } else if (mofObject instanceof TRCNode) {
			  Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

			  for (int idx = 0; idx < processes.length; idx++) {
				  Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

				  for (int i = 0; i < agents.length; i++) {
					  if (((TRCAgentProxy) agents[i]).getAgent() != null) {
					  	
						addAgent(((TRCAgentProxy) agents[i]).getAgent());
						  
					  }
				  }
			  }
		  } else if (mofObject instanceof TRCMonitor) {
			  Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

			  for (int k = 0; k < nodes.length; k++) {
				  Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

				  for (int idx = 0; idx < processes.length; idx++) {
					  Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

					  for (int i = 0; i < agents.length; i++) {
						  if (((TRCAgentProxy) agents[i]).getAgent() != null) {
						  	
							addAgent(((TRCAgentProxy) agents[i]).getAgent());
							  
						  }
					  }
				  }
			  }
		  }
	  }
   }		
}
