/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * Interface to be implemented by classes that needs to specify which
 * resource set should be used to load a given file.
 *  
 * @author marcelop
 * @since 0.2.0
 */
public interface IResourceSetFileAdaptable 
extends IAdaptable
{
	/**
	 * The file to be loaded.
	 * @return IFile
	 */
	public IFile getFile();
	
	/**
	 * The resource set to load the file. 
	 * @return ResourceSet
	 */
	public ResourceSet getResourceSet();
}
