/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.ui.editor.IEditorExtension;


/**
 * @author bcormier
 * @since 3.0.0
 */
public class DefaultTestContextOverviewContribution extends
        TestContextOverviewContribution {

    
    /**
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#createLeftSections(org.eclipse.hyades.ui.editor.IEditorExtension)
     */
    protected FormSection[] createLeftSections(
            IEditorExtension editorExtension) {
        NamedElementsSection testCasesSection = new NamedElementsSection(editorExtension, 1);
        testCasesSection.setDescription(TestUIPlugin.getString("EDT_TST_CASE_DSC")); //$NON-NLS-1$
        testCasesSection.setHeaderText(TestUIPlugin.getString("W_TST_CASES")); //$NON-NLS-1$
        return new NamedElementsSection[] {testCasesSection};
    }
    
    /**
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#createRightSections(org.eclipse.hyades.ui.editor.IEditorExtension)
     */
    protected FormSection[] createRightSections(IEditorExtension editorExtension) {
//        IAction addBtn = new AddDatapoolAction(TestUIPlugin.getString("label.Add")); //$NON-NLS-1$
//        EObjectTableSection datapoolSection = new EObjectTableSection(
//                getOverviewForm(), 
//                Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_Datapools(),
//                new IAction[] {addBtn});
//        datapoolSection.setCollapsable(true);
//        datapoolSection.setHeaderText(TestUIPlugin.getString("W_DATAPOOL")); //$NON-NLS-1$
////        datapoolSection.setDescription(TestUIPlugin.getString("W_DATAPOOL")); //$NON-NLS-1$
//        return new FormSection[] {datapoolSection};
        return new FormSection[0];
    }
    
    /**
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#initializeLeftSections(org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection[])
     */
    protected void initializeLeftSections(FormSection[] leftSections) {
        if (leftSections==null || leftSections.length!=1) 
            return;
        
        // leftSections[0] should be a test cases section
        if (leftSections[0] instanceof NamedElementsSection)
            ((NamedElementsSection)leftSections[0]).initialize(
                getTestContext(), 
                Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(),
                TestUIPlugin.getString("W_TST_CASES")); //$NON-NLS-1$
    }
    
    /**
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#initializeRightSections(org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection[])
     */
    protected void initializeRightSections(FormSection[] rightSections) {
//        if (rightSections==null || rightSections.length!=1) 
//            return;
//        if (rightSections[0] instanceof EObjectTableSection) {
//            ((EObjectTableSection)rightSections[0]).initialize(getTestContext());
//        }

    }
}
