/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.swt.widgets.Composite;


/**
 * This class contributes to the overview of a test context editor.
 * <pre>
 *    _______________________  
 *   | Test Context Editor   |
 *   |_______________________|________________________________________________________ 
 *   |                                                                                |
 *   |  _ General Information __________      _ form2 overview _____________________  |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |______________________________________| |
 *   | |                                |                                             |
 *   | |________________________________|     _ form4 overview _____________________  |
 *   |                                       |                                      | |
 *   |  _ Test Objective _______________     |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |______________________________________| |
 *   | |________________________________|                                             |
 *   |                                                                                |
 *   |  _ form1 overview _______________                                              |
 *   | |                                |                                             |
 *   | |                                |                                             |
 *   | |________________________________|                                             |
 *   |                                                                                |
 *   |________________________________________________________________________________|
 *   |_Overview_|form1| form2 | form3 | form4 |                                       | 
 * </pre>
 * 
 * Among other services, this class allows to chose wether or not the general information
 * and the test objective sections should be diplayed; it also creates the content of the
 * left and right columns (forms overviews).
 * 
 * @author bcormier
 * @since 3.0.0
 */
public class TestContextOverviewContribution {
    protected TestContextOverview overviewForm;
    protected TPFTestSuite testContext;

    /**
     * Returns the test context.
     * @return the test context.
     */
    protected TPFTestSuite getTestContext() {
        return testContext;
    }
    
    /**
     * Stores the test context.
     * @param testContext
     */
    protected void setTestContext(TPFTestSuite testContext) {
        this.testContext = testContext;
    }
    
    /**
     * Adds some information at the bottom of the generic information section.
     * @param genericInfoComposite the composite which represents the generic information section.
     * @param widgetFactory the widget factory which has been used to create the widgets within genericInfoComposite.
     */
    protected void addSouthGenericInformation(Composite genericInfoComposite, WidgetFactory widgetFactory) {
        
    }
    
    /**
     * Used to initialize the information that might been added at the bottom of the generic information section. 
     */
    protected void initializeSouthGenericInformation() {
        
    }
    
    /**
     * Adds some information after the name of the test suite in the generic information section.
     * @param genericInfoComposite the composite which represents the generic information section.
     * @param widgetFactory the widget factory which has been used to create the widgets within genericInfoComposite.
     */
    protected void addCenterGenericInformation(Composite genericInfoComposite, WidgetFactory widgetFactory) {
        
    }
    
    /**
     * Used to initialize the information that might been added after the name of the test suite in the generic information section. 
     */
    protected void initializeCenterGenericInformation() {
        
    }  
    
    /**
     * This method is called by TestContextOverview to create the content of the column on the left.
     * @param editorExtension the editor extension.
     * @return an array of NamedElementsSection which describe the content of the column on the left.
     */
    protected FormSection[] createLeftSections(IEditorExtension editorExtension) {
        return new FormSection[0];
    }
    
    /**
     * This method is called by TestContextOverview to create the content of the column on the right.
     * @param editorExtension the editor extension.
     * @return an array of NamedElementsSection which describe the content of the column on the right.
     */
    protected FormSection[] createRightSections(IEditorExtension editorExtension) {
        return new FormSection[0];
    }
    
    /**
     * This method is used to initialize the sections that belong to the column on the left.
     * @param leftSections the sections in the order in which they have been created thanks to createLeftSections(IEditorExtension editorExtension).
     */
    protected void initializeLeftSections(FormSection[] leftSections) {
        
    }
    
    /**
     * This method is used to initialize the sections that belong to the column on the right.
     * @param rightSections the sections in the order in which they have been created thanks to createRightSections(IEditorExtension editorExtension).
     */
    protected void initializeRightSections(FormSection[] rightSections) {
        
    }
    
    /**
     * This method should be used to dispose all the widgets that have been created in this class.
     */
    protected void dispose() {
        
    }
    
    /**
     * Used to choose wether or not the generic information section should be displayed.
     * @return false if the generic information should be displayed. Otherwise, true.
     */
    protected boolean hideGenericInformation() {
        return false;
    }
    
    /**
     * Used to choose wether or not the test objective section should be displayed.
     * @return false if the test objective section should be displayed. Otherwise, true.
     */
    protected boolean hideTestObjectiveSection() {
	    return false;
	}

    /**
     * @return Returns the overviewForm.
     */
    protected TestContextOverview getOverviewForm() {
        return overviewForm;
    }
    
    /**
     * @param overviewForm The overviewForm to set.
     */
    protected void setOverviewForm(TestContextOverview overviewForm) {
        this.overviewForm = overviewForm;
    }
}
