/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.wizard.TestComponentNewWizard;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class AddTestComponentAction 
extends AddTestSuiteChildAction
{
	/**
	 * Constructor for AddTestComponentAction
	 */
	public AddTestComponentAction()
	{
		super(TestUIPlugin.getString("BTN_ADD"));
		
		setToolTipText(TestUIPlugin.getString("ACT_TST_CMP_ADD_TIP"));
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_TEST_COMPONENT));
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.ADD_TCOMP_ACT);										
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getTestSuite(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		TPFTestSuite testSuite = getTestSuite(getStructuredSelection());
		TestComponentNewWizard testComponentNewWizard = new TestComponentNewWizard();
		testComponentNewWizard.setWindowTitle(TestUIPlugin.getString("WIZ_TST_CMP_TTL"));

		openWizard(testSuite, testComponentNewWizard, "TestComponentWizard");
	}	
}
