package org.eclipse.hyades.test.ui.internal.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;

/**
 * Concrete implementation of IHyadesEditorPart customized for
 * handling Hyades objects stored in resources with file extension equals to 
 * {@link org.eclipse.hyades.test.ui.TestUI#LOCATION_FILE_EXTENSION}.
 * 
 * @author bjiang
 */
public class LocationEditorPart extends BaseEditorPart {
	/**
	 * Constructor for LocationEditorPart.
	 */
	public LocationEditorPart() 
	{
		super(CFGLocation.class);
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IHyadesEditorPart#getFileExtension()
	 */
	public String getFileExtension()
	{
		return ICommonConstants.LOCATION_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.EMFEditorPart#identifyEditorDescriptor(org.eclipse.emf.ecore.EObject)
	 */
	protected IAssociationDescriptor identifyEditorDescriptor(EObject eObject)
	{
		IAssociationMapping editorAssociationMapping = TestUIExtension.getLocationMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		return editorAssociationMapping.getDefaultAssociationDescriptor();
	}
}
