/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Vector;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.PropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.DeploymentForm;
import org.eclipse.hyades.test.ui.internal.editor.form.LocationsForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Hyades deployment editor extension that is suitable for {@link TPFDeployment} objects.
 * 
 * <p>This class is used whenever it is not possible neither to identify nor
 * to locate the appropriate extension editor.
 * 
 * @author marcelop
 * @since 0.0.1
 * @author bjiang 
 * @since	1.3
 */
public class DeploymentEditorExtension
extends ConfigurableObjectEditorExtension
{
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Deployment";
	
	private static final int PAGE_LOCATIONS = 1;	
	private LocationsForm locationsForm;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		if(locationsForm != null)
		{
			locationsForm.dispose();
			locationsForm = null;
		}		
		super.dispose();
	}
	
	protected IConfigurationElement[] collectRegisteredExtensionElements() 
	{
		IConfigurationElement[] extensions = super.collectRegisteredExtensionElements();		
		Vector registeredExts = new Vector();		 
		{
			for( int i = 0; i < extensions.length; i++ )
			{
			   if( extensions[i].getAttribute("appliesTo").equals(PropertyGroupForm.EDITOR_TYPE_DEPLOYMENT))
			   {
				   registeredExts.add( extensions[i] );
			   }
			}
		}		
		
		if( extensions.length == registeredExts.size() )
			return extensions;
	
		IConfigurationElement[] registeredExtensions = new IConfigurationElement[registeredExts.size()];
		for( int i = 0; i < registeredExts.size(); i++ )
		{
			registeredExtensions[i] = (IConfigurationElement)registeredExts.get(i);
		}
		return registeredExtensions;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory)
	{
		DeploymentForm overviewForm = new DeploymentForm(this, widgetFactory);
		overviewForm.setLocationPageIndex(PAGE_LOCATIONS); 
		return overviewForm;
	}
		
	protected void createOtherStaticPages(WidgetFactory widgetFactory)
	{
		// insert a new form of its own which is after the overview form and before any pages added by extensions.
		locationsForm = new LocationsForm(this, widgetFactory);
		getHyadesEditorPart().addPage(locationsForm.createControl());
		getHyadesEditorPart().setPageText(PAGE_LOCATIONS, TestUIPlugin.getString("W_LOCS"));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.IExtensibleEditorExtension#activateExtensionPage(org.eclipse.core.runtime.IConfigurationElement)
	 */
	public int addExtensionPage(IConfigurationElement extensionElement) 
	{
		// if this extension element is not intended for this editor, return -1.
		if( !extensionElement.getAttribute("appliesTo").equals(PropertyGroupForm.EDITOR_TYPE_DEPLOYMENT))
			return -1;
		    
		return super.addExtensionPage(extensionElement);
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		super.refreshContent(data);
		
		locationsForm.load();
		locationsForm.updateTitle();
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		if(PAGE_LOCATIONS == getHyadesEditorPart().getActivePage())
			return (IStructuredSelection)locationsForm.getSelection();
		else
			return super.getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{
		if(index == PAGE_LOCATIONS)
			return locationsForm.activated();
		else
			return super.pageActivated(index);
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
		super.setSelection(structuredSelection);
		
		if(structuredSelection.size() == 1)
		{
			Object object = structuredSelection.getFirstElement();
			if(object instanceof TPFDeployment)
			{
				getHyadesEditorPart().setActivePage(PAGE_OVERVIEW);
				getOverviewForm().selectReveal(structuredSelection);
			}
			else if(object instanceof CFGLocation)
			{
				getHyadesEditorPart().setActivePage(PAGE_LOCATIONS);
				locationsForm.selectReveal(structuredSelection);
			}
		}
	}	
}
