/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;		//added :BGB(12/1/03)
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.ExecutionEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class EventForm
extends EditorForm implements ISelectionChangedListener
{
	private EObjectTreeSection eventSection;
	private CommonEventSection commonEventSection;
	private DetailSection eventDetailSection;
	private DetailSection executionResultDetailSection;
	private StyledText defaultText;
	
	private PageBook rightColumnPageBook; 
	
	private boolean firstActivation = true;
	
	/**
	 * Constructor for EventForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public EventForm(ExecutionEditorExtension executionEditorExtension, WidgetFactory widgetFactory)
	{
		super(executionEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_EXECUTION"));
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		eventSection.getTreeViewer().removeSelectionChangedListener(this);
		eventSection.dispose();
		commonEventSection.dispose();
		eventDetailSection.dispose();
		
		super.dispose();
	}

	/**
	 * Returns the test case suite manipulated by this form.
	 * @return TPFTestSuite
	 */
	protected TPFExecutionResult getExecution()
	{
		return ((ExecutionEditorExtension)getBaseEditorExtension()).getExecution();		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		WorkbenchHelp.setHelp(parent, TestUIPlugin.getID() + ContextIds.EXEC_EDIT_EVENTS);

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		eventSection = new EObjectTreeSection(this, Common_TestprofilePackage.eINSTANCE.getTPFExecutionHistory_ExecutionEvents(), null)
		{
			protected IContentProvider createContentProvider()
			{
				EObjectTreeSection.EObjectContainerContentProvider provider = new EObjectContainerContentProvider(getEditorForm(), getEStructuralFeature())
				{
					protected Object getRegisteredParentChild(Object parent)
					{
						if(parent instanceof TPFExecutionResult)
						{
							TPFExecutionResult executionResult = (TPFExecutionResult)parent;
							if(executionResult.getExecutionHistory() != null)
								return executionResult.getExecutionHistory().getExecutionEvents();
							return null;
						}
						//added to set the parent/child hierarchy for execution events :BGB(12/2/03)
						else if (parent instanceof TPFExecutionEvent)
						{
							if ( parent instanceof TPFInvocationEvent )
							{
								TPFInvocationEvent invocationEvent	= (TPFInvocationEvent)parent;
								return( invocationEvent.getInvokedExecutionResult() );
							}
							else
							{
								TPFExecutionEvent	executionEvent	= (TPFExecutionEvent)parent;
								if ( ( executionEvent.getChildren() != null ) &&
								     ( executionEvent.getChildren().isEmpty() == false ))
								  	return( executionEvent.getChildren());
							}
						}
						return super.getRegisteredParentChild(parent);
					}
					
					public Object getParent(Object element)
					{
						if(element instanceof TPFExecutionResult)
						{
							TPFExecutionResult executionResult = (TPFExecutionResult)element;
							if(executionResult.getInvocationExecutionEvent() != null)
								return executionResult.getInvocationExecutionEvent();
						}
						//added to set the parent/child hierarchy for execution events :BGB(12/2/03)
						else if (element instanceof TPFExecutionEvent)
						{
							TPFExecutionEvent executionEvent	= (TPFExecutionEvent)element;
							return( executionEvent.eContainer());
						}
						
						return super.getParent(element);
					}
				};
				//provider.registerParent(TPFInvocationEvent.class, Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_InvokedExecutionResult());
				return provider;
			}

			protected void adjustButtonLabels(String addLabel)
			{
				setButtonLabels(new String[0]);
			}	
		};
		eventSection.setTreeStryle(SWT.FULL_SELECTION | SWT.SINGLE);
		registerSection(eventSection);
		eventSection.setHeaderText(TestUIPlugin.getString("W_EVENTS"));
		Control control = eventSection.createControl(leftColumn, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));		
		
		rightColumnPageBook = new PageBook(rightColumn, SWT.NONE);
		rightColumnPageBook.setLayoutData(GridDataUtil.createFill());
		rightColumnPageBook.setBackground(getWidgetFactory().getBackgroundColor());
		rightColumnPageBook.addMouseListener(new MouseAdapter()
		{
			public void mousePressed(MouseEvent e)
			{
				((Control) e.widget).setFocus();
			}
		});
		rightColumnPageBook.setMenu(parent.getMenu());

		Composite defaultControl = getWidgetFactory().createComposite(rightColumnPageBook);
		defaultControl.setLayout(new GridLayout());
		defaultControl.setLayoutData(GridDataUtil.createFill());
		getWidgetFactory().createLabel(defaultControl, "");
		defaultText = getWidgetFactory().createStyledText(defaultControl, SWT.FULL_SELECTION | SWT.SINGLE);
		defaultText.setLayoutData(GridDataUtil.createFill());
		//defaultText.setFont(JFaceResources.getBannerFont());
		defaultText.setEnabled(false);
		getWidgetFactory().paintBordersFor(defaultControl);
		
		Composite eventComposite = getWidgetFactory().createComposite(rightColumnPageBook);
		gridLayout = new GridLayout();
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		eventComposite.setLayout(gridLayout);		
		eventComposite.setLayoutData(GridDataUtil.createFill());

		commonEventSection = new CommonEventSection(this);
		commonEventSection.setHeaderText(TestUIPlugin.getString("TTL_CMN_PROPS"));
		registerSection(commonEventSection);		
		control = commonEventSection.createControl(eventComposite, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
		
		eventDetailSection = new DetailSection(this);
		addDetails(eventDetailSection);	
		if(!eventDetailSection.isEmpty())
		{
			eventDetailSection.setHeaderText(TestUIPlugin.getString("TTL_DTL_PROPS"));
			registerSection(eventDetailSection);
			control = eventDetailSection.createControl(eventComposite, getWidgetFactory());
			gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
			control.setLayoutData(gridData);
		}

		executionResultDetailSection = new DetailSection(this);
		executionResultDetailSection.add(TPFExecutionResult.class, new ExecutionResultDetailPage());
		executionResultDetailSection.setHeaderText(TestUIPlugin.getString("W_SUMMARY"));
		registerSection(executionResultDetailSection);
		control = executionResultDetailSection.createControl(rightColumnPageBook, getWidgetFactory());
		gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
		
		rightColumnPageBook.showPage(eventComposite);
		((GridData)rightColumnPageBook.getLayoutData()).heightHint = eventComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT, true).y;			
	}
	
	protected void addDetails(DetailSection detailSection)
	{
		detailSection.add(TPFTypedEvent.class, new TypedEventDetailPage());
		detailSection.add(TPFMessageEvent.class, new MessageEventDetailPage());
		detailSection.add(TPFInvocationEvent.class, new InvocationEventDetailPage());
		detailSection.add(TPFVerdictEvent.class, new VerdictEventDetailPage(this));
		//added to support new loop event :BGB(12/1/03)
		detailSection.add(TPFLoopEvent.class, new LoopEventDetailPage());
	}
	
	public void revealSelect( Object element )
	{
		if ( eventSection != null )
		{
			StructuredSelection selection	= null;
			eventSection.getTreeViewer().reveal( element );
			selection = new StructuredSelection( element );
			eventSection.getTreeViewer().setSelection( selection );
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		updateDefaultText();
			
		eventSection.getTreeViewer().removeSelectionChangedListener(this);
		setInputPreservingExpandedElements();
		eventSection.getTreeViewer().addSelectionChangedListener(this);
	}
	
	protected void setInputPreservingExpandedElements()
	{
		Object[] expandedElements = eventSection.getTreeViewer().getExpandedElements();
		for (int i = 0, maxi = expandedElements.length; i < maxi; i++)
		{
			if(expandedElements[i] instanceof EObject)
				expandedElements[i] = EcoreUtil.getURI((EObject)expandedElements[i]);
		}
		eventSection.setInput(getExecution().getExecutionHistory());
		for (int i = 0, maxi = expandedElements.length; i < maxi; i++)
		{
			if(expandedElements[i] instanceof URI)
				expandedElements[i] = getExecution().eResource().getResourceSet().getEObject((URI)expandedElements[i], false);
		}
		try
		{
			eventSection.getTreeViewer().setExpandedElements(expandedElements);
		}
		catch(Exception e)
		{
		}
	}
	
	protected void updateDefaultText()
	{
		String text = null;
		
		if((getExecution() == null) || (getExecution().getExecutionHistory() == null) || (getExecution().getExecutionHistory().getExecutionEvents().isEmpty()))
			text = TestUIPlugin.getString("MSG_NO_EVE");
		else
			text = TestUIPlugin.getString("MSG_NO_EVE_SEL");
			
		defaultText.setText(text);
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		eventSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == eventSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			if(structuredSelection.size() == 1)
			{
				Object selection = structuredSelection.getFirstElement();
				if(selection instanceof TPFExecutionEvent)
				{
					commonEventSection.setInput(selection);
					if(eventDetailSection != null)
						eventDetailSection.setInput(selection);
					rightColumnPageBook.showPage(rightColumnPageBook.getChildren()[1]);
					return;
				}
				
				if(selection instanceof TPFExecutionResult)
				{
					executionResultDetailSection.setInput(selection);
					rightColumnPageBook.showPage(rightColumnPageBook.getChildren()[2]);
					return;
				}
			}
			
			updateDefaultText();
			rightColumnPageBook.showPage(rightColumnPageBook.getChildren()[0]);
		}
	}
	
	public ISelection getSelection()
	{
		return eventSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			eventSection.setFocus();
		}
			
		return super.activated();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
	}	
}
