/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ISetSelectionTarget;

/**
 * Interface of configuration editor forms that extension instances of Hyades extension point 
 * <i>org.eclipse.hyades.test.ui.configurationEditorForm</i> should implement.
 * 
 * @author bjiang
 * @since  1.3
 */
public interface IPropertyGroupForm extends ISetSelectionTarget
{
	/**
	 * Initialize this form with the {@link CFGPropertyGroup} it is editing, the editor it belongs to 
	 * and a {@link WidgetFactory} of the editor that should be used by all forms of the editor.
	 * 
	 * @param propertyGroup
	 * @param editorExtension
	 * @param widgetFactory
	 */
	public void init(CFGPropertyGroup propertyGroup, BaseEditorExtension editorExtension, WidgetFactory widgetFactory);
	
	/**
	 * Sets which {@link CFGConfigurableObject}'s property group this form is editing.
	 * 
	 * @param configurableObjectName a {@link CFGConfigurableObject} concrete class name. 
	 */
	public void setAppliesto(String configurableObjectName);
	
	/**
	 * Sets the type of the control this form should use.  Select from "table", "tree", "fields" and "custom".
	 * 
	 * @param controlType
	 */
	public void setControlType(String controlType);
	
	//public void setExtension(IConfigurationElement extension);
	
	//public String getPropertyGroupID();
	
	//public String getExtensionID();
	
	/**
	 * Get the name of the {@link CFGPropertyGroup} this form is manipulating to be displayed in GUI.
	 * @return name of the <code>CFGPropertyGroup</code> object.
	 */
	//public String getName();
	
	//public String getDescription();
	
	/**
	 * Returns the {@link CFGPropertyGroup} object this form is editing.
	 */
	public CFGPropertyGroup getPropertyGroup();
	
	/**
	 * Returns the {@link CFGPropertyGroup} this form is manipulating.
	 * @param propertyGroups the complete list of <code>CFGPropertyGroup</code>s from its container.
	 * @return a existing or new <code>CFGPropertyGroup</code> object from the specified list.
	 */
	//public CFGPropertyGroup getCFGPropertyGroup(EList propertyGroups);
	
	/**
	 * Creates the control of this form.
	 * @return Control
	 */
	public Control createControl();
	
	/**
	 * Subclasses should load the persited values to the controls in this method.  
	 * The goal is to provide a common behavior for the editor forms.
	 */
	public void load();
	
	/**
	 * Returns the specific selected object in this form.
	 * @return IStructuredSelection
	 */
	public IStructuredSelection getSelection();

	/**
	 * Sets the selection in this form to be revealed when the form is activated.  This method
	 * is called from the configurable object overview page, when a hyper-link representing one of the 
	 * properties of this property group is activated to bring this form on top.
	 * 
	 * @param selection the selction should be revealed. 
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection);

}
