/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddConfigPropertyAction;
import org.eclipse.hyades.test.ui.internal.dialog.ComparablePropertyInputDialog;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveDownChildrenAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveUpChildrenAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveFeatureChildrenAction;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtil;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;

/**
 * This is the default implementation class of extension point <i>org.eclipse.hyades.test.ui.configurationEditorForm</i>. 
 * Extensions may choose to extend this class or simply use directly.
 * 
 * @author bjiang
 * @since  1.3
 */
public class PropertyGroupForm extends EditorForm implements IPropertyGroupForm
{
	//private IConfigurationElement extensionInstance;
	//private String propertyGroupID;
	//private String extensionID;
	//private String name = null;
	//private String description = null;
	private CFGPropertyGroup propertyGroup;
	private EditorSection mainSection;
	public static final String EDITOR_TYPE_ARTIFACT = "artifact"; //$NON-NLS-1$
	public static final String EDITOR_TYPE_LOCATION = "location"; //$NON-NLS-1$
	public static final String EDITOR_TYPE_DEPLOYMENT = "deployment";  //$NON-NLS-1$
	private String editorType = EDITOR_TYPE_LOCATION;

	public static final String CONTROL_TYPE_CUSTOM = "custom"; //$NON-NLS-1$
	public static final String CONTROL_TYPE_TABLE = "table"; //$NON-NLS-1$
	public static final String CONTROL_TYPE_TREE = "tree"; //$NON-NLS-1$
	public static final String CONTROL_TYPE_FIELDS = "fields"; //$NON-NLS-1$
	private String controlType = CONTROL_TYPE_TABLE;
	
	private RemoveFeatureChildrenAction removeAction;
	
	/**
	 * This is a {@link ITableLabelProvider} class that knows what text to display in 
	 * the table control of a {@link IPropertyGroupForm} with a given {@link CFGComparableProperty} object. 
	 */
	public class PropertyGroupTableLabelProvider extends LabelProvider implements ITableLabelProvider
	{
	
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex) 
		{
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) 
		{
			if(element instanceof CFGComparableProperty)
			{
				CFGComparableProperty property = (CFGComparableProperty)element;
				switch(columnIndex)
				{
					case 0:
						return property.getName();
					case 1:
						return property.getOperator();
					case 2:
						return property.getValue();
				}
			}
			
			return null;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm#init(org.eclipse.hyades.models.common.configuration.CFGPropertyGroup, org.eclipse.hyades.test.ui.internal.editor.extension.BaseEditorExtension, org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory)
	 */
	public void init(CFGPropertyGroup propertyGroup, BaseEditorExtension editorExtension, WidgetFactory widgetFactory)
	{
		this.propertyGroup = propertyGroup;
		super.init(editorExtension, widgetFactory);
	}
	
	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm#setAppliesto(java.lang.String)
	 */
	public void setAppliesto(String configurableObjectName)
	{
		if(configurableObjectName.equals(EDITOR_TYPE_DEPLOYMENT)) 
			this.editorType = EDITOR_TYPE_DEPLOYMENT;
		else
			this.editorType = EDITOR_TYPE_LOCATION;
	}
	
	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm#setControlType(java.lang.String)
	 */
	public void setControlType(String controlType)
	{
		this.controlType = controlType;			
	}
	
/*
	public void setExtension(IConfigurationElement extension)
	{
		this.extensionInstance = extension;
		this.propertyGroupID = extension.getAttribute("propertyGroupID");
		this.extensionID = extension.getAttribute("id");
		this.name = extension.getAttribute("name");
		this.description = extension.getAttribute("description");
		if( extension.getAttribute("appliesTo").equals(EDITOR_TYPE_DEPLOYMENT)) 
			this.editorType = EDITOR_TYPE_DEPLOYMENT;
		else
			this.editorType = EDITOR_TYPE_LOCATION;
		this.controlType = extension.getAttribute("controlType");
		
		EList propertyGroups = null;		
		if( editorType.equals(EDITOR_TYPE_DEPLOYMENT) )
		{
			setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT"));
			propertyGroups = ((TPFDeployment)getEditorObject()).getPropertyGroups();	
		}
		else if( editorType.equals(EDITOR_TYPE_LOCATION) )
		{
			setHeadingText(TestUIPlugin.getString("W_LOCATION"));
			propertyGroups = ((CFGLocation)getEditorObject()).getPropertyGroups();	
		}
		propertyGroup = getCFGPropertyGroup(propertyGroups);	
	}
	

	private CFGPropertyGroup getCFGPropertyGroup(EList propertyGroups)
	{
		CFGPropertyGroup propertyGroup = null;
		for( Iterator i = propertyGroups.iterator(); i.hasNext(); )
		{			
			propertyGroup = (CFGPropertyGroup)i.next();
			if( getPropertyGroupID().equals(propertyGroup.getGroupID()) )
				break;
			else
				propertyGroup = null;			
		}

		if( propertyGroup == null ) 
		{
			propertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
			propertyGroup.setGroupID(propertyGroupID);
			propertyGroup.setName(name);
			propertyGroups.add(propertyGroup);
		}
		
		return propertyGroup;
	}
*/	
	
	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm#getPropertyGroup()
	 */
	public CFGPropertyGroup getPropertyGroup()
	{
		return propertyGroup;
	}
	
	/**
	 * Returns the type of the control this form contains.
	 * 
	 * @return one of "table", "tree", "fields" or "custom".
	 */
	public String getControlType()
	{
		return this.controlType;
	}

	/**
	 * Returns which {@link CFGConfigurableObject}'s property group this form is editing.
	 * 
	 * @return a {@link CFGConfigurableObject} concrete class name. 
	 */
	public String getAppliesTo()
	{
		return this.editorType;
	}

/*	public String getName()
	{
		return this.name;
	}
	
	public String getDescription()
	{
		return description;
	}
	
	public String getPropertyGroupID()
	{
		return this.propertyGroupID;
	}
	
	public String getExtensionID()
	{
		return this.extensionID;
	}
*/
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		//namedElementSection.dispose();
		//namedElementSection = null;
		super.dispose();
	}
	
	/**
	 * Returns the data object that is manipulated by the editor that this form belongs.
	 * @return EObject 
	 */
	protected EObject getEditorObject()
	{
		return ((ConfigurableObjectEditorExtension)getBaseEditorExtension()).getEditorObject();
	}
	
	/**
	 * Creates the contents of this editor form.
	 * @param parent
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		if( controlType.equals(CONTROL_TYPE_TREE) )
		{
			mainSection = createTreeSection(leftColumn);
		}
		else if( controlType.equals(CONTROL_TYPE_TABLE) )
		{
			mainSection = createTableSection(leftColumn);
		}
		else if( controlType.equals(CONTROL_TYPE_FIELDS) )
		{
		}
		else
		{
		}
		
		if(mainSection != null)
		{
			registerSection(mainSection);
			mainSection.setHeaderText(propertyGroup.getName());
			mainSection.setCollapsable(true);
			Control control = mainSection.createControl(leftColumn, getWidgetFactory());
			control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));
		}
	}
	
	/**
	 * Creates a tree section with <i>add, remove, move up, move down</i> buttons as the main control of this form.
	 * @param parent 
	 * @return a {@link EditorSection}
	 */
	protected EditorSection createTreeSection(Composite parent)
	{
		AddConfigPropertyAction addPropertyAction = new AddConfigPropertyAction(propertyGroup, HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_LOCATION))
		{
			protected CFGComparableProperty[] addProperties()
			{
				return PropertyGroupForm.this.addProperties();
			}
		};
		return new EObjectTreeSection(this, Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), addPropertyAction); 									
	}
	
	/**
	 * Creates a table section with <i>add, remove, move up, move down</i> buttons as the main control of this form.
	 * @param parent 
	 * @return a {@link EditorSection}
	 */
	protected EditorSection createTableSection(Composite parent)
	{
		ExtensibleEObjectTableSection tableSection = new ExtensibleEObjectTableSection(this, Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), 3, createButtonActions());
		tableSection.setLabelProvider(new PropertyGroupTableLabelProvider());	
		return tableSection;	
	}
	
	/**
	 * Creates the actions of the buttons that the primary editor section will use. 
	 * @return
	 */
	protected IAction[] createButtonActions()
	{
		IAction[] buttonActions = new IAction[4];
		buttonActions[0] = new AddConfigPropertyAction( propertyGroup, HyadesUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_LOCATION))
		{
			protected CFGComparableProperty[] addProperties()
			{
				return PropertyGroupForm.this.addProperties();
			}
		};
		//buttonActions[1] = removeAction = new RemoveChildrenAction(false);	
		//buttonActions[2] = new MoveChildrenUpAction();
		//((MoveChildrenUpAction)buttonActions[2]).setEStructuralFeature(Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
		//buttonActions[3] = new MoveChildrenDownAction();
		//((MoveChildrenDownAction)buttonActions[3]).setEStructuralFeature(Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
		
		buttonActions[1] = removeAction = new RemoveFeatureChildrenAction(getPropertyGroup(), Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), false);	
		buttonActions[2] = new MoveUpChildrenAction(getPropertyGroup(), Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
		buttonActions[3] = new MoveDownChildrenAction(getPropertyGroup(), Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
		return buttonActions;
	}
	
	/**
	 * Adds one or more {@link CFGComarableProperty}. This method is called when the <i>Add...</i> button is 
	 * selected.
	 * 
	 * @return
	 */
	protected CFGComparableProperty[] addProperties()
	{
		CFGComparableProperty[] newProperties = null;
		if(controlType.equals(CONTROL_TYPE_TABLE))
		{
			// TODO new property dialog
			ComparablePropertyInputDialog dialog = new ComparablePropertyInputDialog(Display.getCurrent().getActiveShell(), TestUIPlugin.getString("DLG_NEW_PROPERTY")); //$NON-NLS-1$
			dialog.open();
			
			CFGComparableProperty newProperty = dialog.getProperty();		
			newProperties = new CFGComparableProperty[1];
			newProperties[0] = newProperty;			
		}
		else if(controlType.equals(CONTROL_TYPE_TREE))
		{
//			create default new element
			String newName = TestUIUtil.getUniqueName(TestUIPlugin.getString("W_COUNTER"), propertyGroup.getProperties()); //$NON-NLS-1$
			CFGComparableProperty newCounter = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
			newCounter.setName(newName);
			newProperties = new CFGComparableProperty[1];
			newProperties[0] = newCounter;					
		}
		
		return newProperties;
	}

	/**
	 * Subclasses should load the persited values in the controls in this method.  
	 * The goal is to provide a common behavior for the editor forms.
	 */
	public void load()
	{		
		if( controlType.equals(CONTROL_TYPE_TREE) )
		{
			EObjectTreeSection section = (EObjectTreeSection)mainSection;
			//section.getTreeViewer().removeSelectionChangedListener(section);
			section.setInput(propertyGroup);
			//section.getTreeViewer().addSelectionChangedListener(section);
		}
		else if( controlType.equals(CONTROL_TYPE_TABLE) )
		{
			ExtensibleEObjectTableSection section = (ExtensibleEObjectTableSection)mainSection;
			section.getTableViewer().removeSelectionChangedListener(section);
			section.setInput(propertyGroup);
			section.getTableViewer().addSelectionChangedListener(section);
		}
		else if( controlType.equals(CONTROL_TYPE_FIELDS) )
		{
		}
		else
		{
		}
	}	
	
	/**
	 * Subclass should override this method to return the specific selected object in the form.
	 * This default implementation just returns the data object of the overall editor.
	 * @return IStructuredSelection
	 */
	public IStructuredSelection getSelection()
	{
		return new StructuredSelection(getEditorObject());
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		mainSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#doGlobalAction(java.lang.String)
	 */
	public boolean doGlobalAction(String actionId)
	{
		if (actionId.equals(ActionFactory.DELETE.getId()))
		{
			if(removeAction != null)
				removeAction.run();
			return true;
		}
		return false;
	}

}
