/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.base.SelectableFormLabel;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;

/**
 * @author bjiang
 */
public class ExtensionElementLink implements IHyperlinkListener, DisposeListener
{
	private IExtensibleEditorExtension editorExtension;
	private SelectableFormLabel hyperlink;
	
	/**
	 * Constructor for ExtensionElementLink
	 */
	public ExtensionElementLink(IExtensibleEditorExtension editorExtension )
	{
		this.editorExtension = editorExtension;
	}
	
	public void create(FormWidgetFactory widgetFactory, Composite parent, IConfigurationElement extensionElement)
	{
		if(hyperlink != null)
			return;
		
		ImageDescriptor imageDescriptor = null;
		imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_PROPERTY_GROUP);

		Label imageLabel = widgetFactory.createLabel(parent, ""); //$NON-NLS-1$
		imageLabel.setImage(imageDescriptor.createImage());

		String propertyGroupID = extensionElement.getAttribute("propertyGroupID"); //$NON-NLS-1$
		if(propertyGroupID == null)
			propertyGroupID = ""; //$NON-NLS-1$
		String tooltip = propertyGroupID;

		hyperlink =	widgetFactory.createSelectableLabel(parent, propertyGroupID);
		widgetFactory.turnIntoHyperlink(hyperlink, this);
		hyperlink.addDisposeListener(this);
		hyperlink.setToolTipText(tooltip);
		hyperlink.setData(extensionElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkActivated(org.eclipse.swt.widgets.Control)
	 */
	public void linkActivated(Control linkLabel) 
	{
		Object linkData = linkLabel.getData();
		editorExtension.setSelection(new StructuredSelection(linkData));
		
		if(linkData != null && (linkData instanceof IConfigurationElement))
		{			
			int index = editorExtension.addExtensionPage((IConfigurationElement)linkData);
			editorExtension.getHyadesEditorPart().setActivePage( index );
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkEntered(org.eclipse.swt.widgets.Control)
	 */
	public void linkEntered(Control linkLabel) {
		IActionBars actionBars = editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setMessage(((SelectableFormLabel)linkLabel).getText());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkExited(org.eclipse.swt.widgets.Control)
	 */
	public void linkExited(Control linkLabel) {
		IActionBars actionBars = editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		manager.setMessage(""); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.DisposeListener#widgetDisposed(org.eclipse.swt.events.DisposeEvent)
	 */
	public void widgetDisposed(DisposeEvent e) {
		if(hyperlink != null)
		{
			hyperlink.removeDisposeListener(this);
			hyperlink.setData(null);
			hyperlink = null;
		}
		editorExtension = null;
	}

}
