/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * @author marcelop
 * @since 0.2.0
 * @deprecated Use org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection instead.
 */
public class NamedElementSection 
extends EditorSection implements ModifyListener
{
	private StyledText nameText;
	private StyledText descriptionText;
	
	private CMNNamedElement namedElement;

	/**
	 * Constructor for NamedElementSection
	 * @param editorForm 
	 */
	public NamedElementSection(EditorForm editorForm)
	{
		super(editorForm);
		setCollapsable(true);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		namedElement = null;
		super.dispose();
	}

	protected CMNNamedElement getNamedElement()
	{
		return namedElement;
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.update.ui.forms.internal.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
				
		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_NAME"));
		nameText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		nameText.setLayoutData(GridDataUtil.createHorizontalFill());
		nameText.setEditable(false);
				
		addCenterControls(composite, formWidgetFactory);
				
		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_DESC"));
		descriptionText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = 4*descriptionText.getLineHeight();
		descriptionText.setLayoutData(gridData);
		descriptionText.setEditable(false);
								
		addSouthControls(composite, widgetFactory);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	protected void addCenterControls(Composite parent, FormWidgetFactory formWidgetFactory)
	{
	}

	protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory)
	{
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		namedElement = null;

		nameText.removeVerifyKeyListener(this);
		nameText.removeModifyListener(this);
		descriptionText.removeVerifyKeyListener(this);
		descriptionText.removeModifyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof CMNNamedElement)
		{
			namedElement = (CMNNamedElement)object;
			
			String value = getNamedElement().getName();
			if(value != null)
				nameText.setText(value);
			else
				nameText.setText("");
			
			value = getNamedElement().getDescription();
			if(value != null)
				descriptionText.setText(value);
			else
				descriptionText.setText("");	

			nameText.setEditable(true);
			descriptionText.setEditable(true);			
		}
		else
		{
			nameText.setText("");
			descriptionText.setText("");

			nameText.setEditable(false);
			descriptionText.setEditable(false);			
		}
		
		nameText.addVerifyKeyListener(this);
		nameText.addModifyListener(this);
		descriptionText.addVerifyKeyListener(this);
		descriptionText.addModifyListener(this);					
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return namedElement;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection()
	{
		if(namedElement == null)
			return StructuredSelection.EMPTY;
		return new StructuredSelection(namedElement);
	}

	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{

	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == nameText)
		{
			getNamedElement().setName(nameText.getText());
			getEditorForm().updateTitle();
			getEditorForm().getBaseEditorExtension().markDirty();
		}
		else if(e.widget == descriptionText)
		{
			getNamedElement().setDescription(descriptionText.getText());
			getEditorForm().getBaseEditorExtension().markDirty();
		}
	}
	
	protected StyledText getNameTextField()
	{
		return this.nameText;
	}
	
	protected StyledText getDescriptionTextField()
	{
		return this.descriptionText;
	}
}