/*
 * Created on Dec 31, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.test.ui.internal.editor.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.ui.PartInitException;

/**
 * This class is used to create xmi resource for the location of configuration editor.
 * 
 * @author bjiang
 */
public class LocationResourceFactory {
	
	static public EObject create(IFile file, String name, String description)
	throws Exception
	{
		Resource resource = createResource(file);
		EObject eObject = createEObject(name, description);
		resource.getContents().add(eObject);
		EMFUtil.save(resource);
		return eObject;
	}

	/**
	 * Creates the EObject setting the attributes based on the specified information.
	 * @return a not null EObject
	 */
	static protected EObject createEObject(String name, String description)
	{
		CFGMachineConstraint machine = Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint();
		machine.setName(name);				
		String hostName = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.DEFAULT_HOST_NAME);	
		machine.setHostname(hostName);	

		if((description != null) && (description.trim().length() > 0))
		machine.setDescription(description);
		
		return machine;
	}

	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	static public Resource createResource(IFile file)
	{
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString());
		Resource.Factory factory = EMFUtil.getResourceFactory(ICommonConstants.LOCATION_FILE_EXTENSION);
		return factory.createResource(uri);
	}

	static public String getFileExtension()
	{
		return ICommonConstants.LOCATION_FILE_EXTENSION;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	static public void openEditor(IFile file) 
	throws PartInitException
	{
		if(TestUIPlugin.getInstance().getPreferenceStore().getBoolean(TestUI.OPEN_EDITOR))
			UIUtil.openEditor(file, TestUIExtension.DEPLOYMENT_EDITOR_PART_ID, false);
	}

}
