/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionListenerAction;

import org.eclipse.hyades.ui.util.IDisposable;

/**
 * This action works on EMF objects that are contained by another EMF object. 
 * @author marcelop
 * @since 0.3.0
 */
public class ChildrenSelectionAction 
extends SelectionListenerAction implements IDisposable
{
	private StructuredViewer structuredViewer;
	private List children;
	private boolean actionPerformed;
	
	//added by bjiang to handle any EStructuralFeature Children selection of an EObject 3/3/2004
	private EObject parent;
	private EStructuralFeature eStructuralFeature;

	/**
	 * Constructor for ChildrenSelectionAction
	 * @param text
	 */
	public ChildrenSelectionAction(String text)
	{
		super(text);
	}
	
	/**
	 * Constructs an instance of this class that handles the selection of EStructuralFeature of the 
	 * specified parent.  
	 * @param text
	 * @param parent
	 * @param feature
	 * 
	 * @author bjiang
	 */
	public ChildrenSelectionAction(String text, EObject parent, EStructuralFeature feature)
	{
		super(text);
		this.parent = parent;
		if(feature.isMany())
			this.eStructuralFeature = feature;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		if(children != null)
			children.clear();
		structuredViewer = null;
	}
	
	/**
	 * Returns the children obtained from the last selection update.  All the
	 * objects are EObjects.   This information is reset at the end of an 
	 * execution and when the selection changes.
	 * @return List
	 */
	protected List getChilren()
	{
		if(children == null)
			children = new ArrayList();
		return children;
	}
	
	/**
	 * Returns the value of the EStructuralFeature of the parent or <code>null</code> if either 
	 * the parent or EStructuralFeature is <code>null</code>.
	 * 
	 * @author bjiang
	 */
	protected EList getEStructuralFeatureValue()
	{
		if(parent == null || eStructuralFeature == null)
			return null;
			
		return (EList)parent.eGet(eStructuralFeature);
	}
	
	/**
	 * Sets the action performed flag.
	 * @param actionPerformed
	 */
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPerformed = actionPerformed;
	}
	
	/**
	 * Returns whether the most run has being completed.  This information is reset 
	 * at the selection changes. 
	 * @return boolean.
	 */
	public boolean actionPerformed()
	{
		return actionPerformed;
	}

	/**
	 * Sets the structuredViewer that should be updated after running this action.
	 * @param structuredViewer
	 */
	public void setStructuredViewer(StructuredViewer structuredViewer)
	{
		this.structuredViewer = structuredViewer;
	}

	/**
	 * Returns the structuredViewer to be updated after running this action.
	 * @return structuredViewer
	 */
	public StructuredViewer getStructuredViewer()
	{
		return structuredViewer;
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		setActionPerformed(false);
		if(children != null)
			children.clear();
		
		if(selection.isEmpty())
			return false;
		
		List childCandidates = new ArrayList();
		for (Iterator i = selection.iterator(); i.hasNext();)
		{
			Object object = i.next();
			if(!(object instanceof EObject))
				return false;
				
			//if(((EObject)object).eContainer() == null)
				//return false;
				
			childCandidates.add(object);
		}
		
		getChilren().addAll(childCandidates);
		return !getChilren().isEmpty();
	}

}
