/*
 * Created on 1 mars 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.HashMap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;



/**
 * @author kdarcour
 *
 * The singleton class VisibleTypes lists the whole types and their provider in a Map initialized in 2 times. 
 * 
 */
public class VisibleTypes
{
	private static VisibleTypes theInstance = null;
	private HashMap types;
	
	public static VisibleTypes getInstance() 
	{
		if (theInstance == null) 
			theInstance = new VisibleTypes();
		return theInstance;
	}
		
	/** Returns the associated provider for the given type of element found in the HTN
	 * 
	 * @param type the type of elements (this type shoudlhas been declared through the extension point <code>org.eclipse.hyades.test.ui.testNavigatorType</code>
	 * @return a provider for the given type <code>type</code> or <code>null</code> if the type does not exist (or problem has been encountered)
	 */
	public IHyadesTestNavigatorProvider getProvider(String type) {
		IHyadesTestNavigatorProvider provider = null;
		if(types.containsKey(type)) {
			Object value = types.get(type);
			if (value instanceof IConfigurationElement) {
				//- if the provider has not yet been loaded
				IConfigurationElement element = (IConfigurationElement) value;
				try {
					provider = (IHyadesTestNavigatorProvider)element.createExecutableExtension("provider");
					types.put(type, provider);
				} catch (CoreException e) {
					provider = null;
				}
			} else {
				//- the provider has been loaded yet
				if (value instanceof IHyadesTestNavigatorProvider) {
					provider = (IHyadesTestNavigatorProvider) value;
				}
			}
		}
		return provider;
	}

	private VisibleTypes() 
	{
		types = new HashMap();
		IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint(TestUIPlugin.getID() + ".testNavigatorType");
		if (extPoint != null) 
		{
			IConfigurationElement[] members = extPoint.getConfigurationElements();
			String typeName;
			for (int i = 0; i < members.length; i++) 
			{
				if (members[i].getName() != null) 
				{
					//- get extension of files we want to make visible
					IConfigurationElement element = members[i];
					typeName = element.getAttribute("targetType");
					types.put(typeName,element);
				}
			}
		}
	}
	
}
