/*
 * Created on 23 fvr. 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

/**
 * @author kdarcour
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ExecutionHTNDecorator implements ILightweightLabelDecorator 
{
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILightweightLabelDecorator#decorate(java.lang.Object, org.eclipse.jface.viewers.IDecoration)
	 */
	public void decorate(Object element, IDecoration decoration)
	{
		try
		{
			if (element instanceof TPFExecutionResult) 
			{
				TPFExecutionResult result = (TPFExecutionResult) element;

				switch (result.getVerdict().getValue())
				{
					case TPFVerdict.ERROR:
						decoration.addOverlay(ExecutionVerdictImages.errorVerdict);  break;
					case TPFVerdict.FAIL:
						decoration.addOverlay(ExecutionVerdictImages.failedVerdict);  break;
					case TPFVerdict.INCONCLUSIVE:
						decoration.addOverlay(ExecutionVerdictImages.inconclusiveVerdict); break; 
					case TPFVerdict.PASS:
						decoration.addOverlay(ExecutionVerdictImages.passedVerdict); break;
					default:
						return;	
				}
			}
		}
		catch (Exception e)
		{
			TestUIPlugin.logError(e);
		}
	}


	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) 
	{	
		// TODO Auto-generated method stub
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() 
	{
		// TODO Auto-generated method stub
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) 
	{
		// TODO Auto-generated method stub
		return false;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) 
	{
		// TODO Auto-generated method stub
	}
	
}