/*
 * Created on 2 mars 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

/**
 * @author kdarcour
 *
 * Set of images that are used for decorating TPFExecutionResult
 * depending on the verdict.
 *   
 */

public class ExecutionVerdictImages 
{
	  /**
	   * Passed verdict Image Descriptor
	   */ 
	  public static final ImageDescriptor passedVerdict = 
	  	TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_VERDICT_PASSED);
	  
	  /**
	   * Error verdict Image Descriptor
	   */ 
	  public static final ImageDescriptor errorVerdict = 
	  	TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_VERDICT_ERROR);
	  
	  /**
	   * Failed verdict Image Descriptor
	   */ 
	  public static final ImageDescriptor failedVerdict = 
	  	TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_VERDICT_FAILED);
	    
	  /**
	   * Inconclusive verdict Image Descriptor
	   */ 
	  public static final ImageDescriptor inconclusiveVerdict = 
	  	TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_VERDICT_INC);
	  
	  
	  /**
	   * Constructor
	   */
	  public ExecutionVerdictImages()
	  {
	    super();
	  }

	  /**
	   * Get the passed image data
	   * 
	   * @return image data for the passed verdict
	   */   
	  public ImageData getPassedImageData()
	  {
	    return passedVerdict.getImageData();
	  }
	  
	  /**
	   * Get the error image data
	   * 
	   * @return image data for the error verdict
	   */ 
	  public ImageData getErrorImageData()
	  {
	    return errorVerdict.getImageData();
	  }

	  /**
	   * Get the failed image data
	   * 
	   * @return image data for the failed verdict
	   * 
	   */   
	  public ImageData getFailedImageData()
	  {
	    return failedVerdict.getImageData();
	  }
	  
	  /**
	   * Get the inconclusive image data
	   * 
	   * @return image data for the inconclusive verdict
	   * 
	   */   
	  public ImageData getInconclusiveImageData()
	  {
	    return inconclusiveVerdict.getImageData();
	  }
	  
	  /**
	   * Get the image data depending on the verdict
	   * 
	   * @return image data 
	   * 
	   */ 
	  public ImageData getImageData(String imageKey)
	  {
	    if (imageKey.equals("Passed"))
	    {
	      return getPassedImageData();
	    }
	    if (imageKey.equals("Error"))
	    {
	      return getErrorImageData();
	    }
	    if (imageKey.equals("Failed"))
	    {
	      return getFailedImageData();
	    }
	    if (imageKey.equals ("Inconclusive"))
	    {
	      return getInconclusiveImageData();
	    }
	    return null;
	  }

}
