/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * Hyades Test UI perspective.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestPerspectiveFactory 
implements IPerspectiveFactory
{
	public void createInitialLayout(IPageLayout layout)
	{
		String editorArea = layout.getEditorArea();
		
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT, (float)0.25, editorArea);
		left.addView(TestNavigator.ID);
// BCO		left.addView(ExecutionNavigator.ID);
		
		IFolderLayout bottonLeft = layout.createFolder("bottonLeft", IPageLayout.BOTTOM, (float)0.55, "left");
		bottonLeft.addView(IPageLayout.ID_OUTLINE);
		bottonLeft.addView(IPageLayout.ID_PROP_SHEET);
		
		IFolderLayout botton = layout.createFolder("botton", IPageLayout.BOTTOM, (float)0.80, editorArea);
		botton.addView(IPageLayout.ID_TASK_LIST);

		layout.addShowViewShortcut(TestNavigator.ID);
// BCO		layout.addShowViewShortcut(ExecutionNavigator.ID);		
		layout.addShowViewShortcut(IPageLayout.ID_TASK_LIST);
		layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
	}
}