/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.PartInitException;

/**
 * Extends the HyadesNewWizard to create the Hyades Generic Artifact.
 * 
 * @author psun
 * @since 0.0.1
 * @author bjiang
 * @since 1.3
 */
public class ArtifactNewWizard extends HyadesNewWizard {
	
	private CFGArtifact newArtifact;

	/**
	 * Constructor for LocationNewWizard
	 */
	public ArtifactNewWizard()
	{
		super();
		setWindowTitle(TestUIPlugin.getString("WIZ_ARTIFACT_TTL"));
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWARTIFACT));

		IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("AritfactNewWizard");
		if(settings == null)
			settings = dialogSettings.addNewSection("ArtifactNewWizard");
		setDialogSettings(settings);
	}

	/**
	 * Returns the type for the datapool created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestUIExtension.GENERIC_ARTIFACT_TYPE;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	public String getFileExtension()
	{
		return ICommonConstants.ARTIFACT_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_TTL"));
		getLocationPage().setDescription(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_LOC_DSC"));
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_TTL"));
		getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_ATT_DSC"));
		addPage(getAttributeWizardPage());
		
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		Resource resource = createResource(file);
		resource.getContents().add(createEObject());
		EMFUtil.save(resource);
		return true;
	}
	
	/**
	 * Creates the EObject setting the attributes based on the information
	 * the user has defined in this wizard's pages.
	 * @return a not null EObject
	 */
	protected EObject createEObject()
	{
		newArtifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
		newArtifact.setName(getAttributeWizardPage().getItemName());		
		String description = getAttributeWizardPage().getItemDescription();
		if((description != null) && (description.trim().length() > 0))
		newArtifact.setDescription(description);

		return newArtifact;
	}
	
	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	protected Resource createResource(IFile file)
	{
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString());
		Resource.Factory factory = EMFUtil.getResourceFactory(ICommonConstants.ARTIFACT_FILE_EXTENSION);
		return factory.createResource(uri);
	}

		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		if(TestUIPlugin.getInstance().getPreferenceStore().getBoolean(TestUI.OPEN_EDITOR))
			UIUtil.openEditor(file, TestUIExtension.ARTIFACT_EDITOR_PART_ID, false);
	}	
	
	public CFGArtifact getNewArtifact()
	{
		return this.newArtifact;
	}

}
