/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

/**
 * A page to select which wizard will help the user to create a test case.
 * 
 * @author pnedelec
 * @since 3.0.0
 */
public class TestCaseSelectionPage extends SelectionPage {
    private ITestSuite testSuite;

    /**
     * Constructor
     */
    public TestCaseSelectionPage(String pageName, IWorkbench workbench, IStructuredSelection structuredSelection) {
        super(pageName, workbench, structuredSelection, new IWizardElement[0], ""); //$NON-NLS-1$
        this.testSuite = null;
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage#createWizardNode(org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement)
     */
    protected IWizardNode createWizardNode(IWizardElement wizardElement) {
        IWizardNode wizardNode = (IWizardNode) wizardElement.getAdapter(IWizardNode.class);
        if ((wizardNode != null) && (!wizardNode.isContentCreated())) {
            IWizard wizard = wizardNode.getWizard();
            if (wizard instanceof ITestCaseWizard) {
                if (testSuite != null) {
                    ((ITestCaseWizard) wizard).setTestSuite(testSuite);
                }
                ((IWorkbenchWizard) wizard).init(getWorkbench(), getStructuredSelection());
                wizard.addPages();
            }
        }
        return wizardNode;
    }

    /**
     * Sets the test suite in which the test case will be added.
     * 
     * @param ts
     */
    public void setTestSuite(ITestSuite ts) {
        this.testSuite = ts;
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.selection.SelectionPage#setWizardElements(org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement[])
     */
    public void setWizardElements(IWizardElement[] elements) {
        setErrorMessage(null);
        super.setWizardElements(elements);
        if (elements.length <= 0) {
            if (testSuite != null) {
                String tsType = testSuite.getType();
                setErrorMessage(TestUIPlugin.getString("WIZ_SEL_TST_CASE_EMPTY_WITH_TYPE_MSG", tsType)); //$NON-NLS-1$
            } else {
                setErrorMessage(TestUIPlugin.getString("WIZ_SEL_TST_CASE_EMPTY_MSG")); //$NON-NLS-1$
            }
        }
    }

}
