/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;

public class TraceProcess {
    private TRCProcess process;
    private Iterator iterator;
    private double startTime;
    private double currentRelativeTime;
    private TRCFullMethodInvocation methodInvocation;

    public TraceProcess(TRCProcess tRCProcess) {
        this.process = tRCProcess;
    }

    public void init() {
        this.iterator = this.process.getInvocations().iterator();
        this.startTime = TraceInteractionUtils.getAbsoluteEntryTime(this.process);
        this.nextInvocation();
    }

    public TRCProcess getProcess() {
        return this.process;
    }

    public boolean hasNext() {
        return this.methodInvocation != null;
    }

    public double getCurrentTime() {
        return TraceInteractionUtils.getAbsoluteEntryTime(this.process.getAgent()) + this.currentRelativeTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public TRCFullMethodInvocation nextInvocation() {
        TRCFullMethodInvocation tRCFullMethodInvocation = this.methodInvocation;
        if (this.iterator.hasNext()) {
            this.methodInvocation = (TRCFullMethodInvocation)this.iterator.next();
            this.currentRelativeTime = this.methodInvocation.getEntryTime();
        } else {
            this.methodInvocation = null;
            this.currentRelativeTime = this.process.getLastEventTime();
        }
        return tRCFullMethodInvocation;
    }
}

