/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class TestInvocationDetailPage
extends DetailSection.DetailPage
implements SelectionListener,
IHyperlinkListener {
    protected static final int HELP_PAGE_CONTROL = 1;
    protected static final int HELP_SYNCHRONOUS_CONTROL = 2;
    protected static final int HELP_FILE_CONTROL = 3;
    protected static final int HELP_EDIT_CONTROL = 4;
    protected static final int HELP_TYPE_CONTROL = 5;
    private Button synchronousButton;
    private SelectableFormLabel testLink;
    private Label imageLabel;
    private StyledText typeText;
    private StyledText fileText;
    private Button editButton;
    private ITestInvocation testInvocation;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public void dispose() {
        if (this.testLink != null && !this.testLink.isDisposed()) {
            this.testLink.setData(null);
        }
        this.testInvocation = null;
    }

    public Control createControl(Composite composite, FormWidgetFactory formWidgetFactory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.synchronousButton = widgetFactory.createButton(composite2, this.getSynchronousLabel(), 32);
        this.synchronousButton.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Composite composite3 = widgetFactory.createComposite(composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridDataUtil.createFill());
        this.createTestLink(composite3);
        this.editButton = widgetFactory.createButton(composite3, TestCommonPlugin.getString("label.Update"), 8);
        this.editButton.setLayoutData((Object)new GridData(2));
        widgetFactory.paintBordersFor(composite2);
        this.registerHelp(1, composite2);
        this.registerHelp(1, this.synchronousButton);
        this.registerHelp(1, this.fileText);
        this.registerHelp(1, this.editButton);
        this.registerHelp(1, this.typeText);
        return composite2;
    }

    protected abstract String getSynchronousLabel();

    protected void registerHelp(int n, Object object) {
    }

    protected void createTestLink(Composite composite) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        Composite composite3 = widgetFactory.createComposite(composite2);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.imageLabel = widgetFactory.createLabel(composite3, "");
        this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
        this.testLink = widgetFactory.createSelectableLabel(composite3, "");
        this.testLink.setText(this.getDeftaultLinkText());
        this.testLink.setToolTipText(this.getDeftaultLinkToolTip());
        widgetFactory.turnIntoHyperlink((Control)this.testLink, (IHyperlinkListener)this);
        Composite composite4 = widgetFactory.createComposite(composite2);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)GridDataUtil.createFill());
        widgetFactory.createLabel(composite4, TestCommonPlugin.getString("L_TYPE"));
        this.typeText = widgetFactory.createStyledText(composite4, 65540);
        this.typeText.setEnabled(false);
        this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite4, TestCommonPlugin.getString("L_FILE"));
        this.fileText = widgetFactory.createStyledText(composite4, 65540);
        this.fileText.setEnabled(false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
    }

    protected String getDeftaultLinkText() {
        return "x";
    }

    protected String getDeftaultLinkToolTip() {
        return "";
    }

    public void setInput(Object object) {
        IStructuredSelection iStructuredSelection;
        this.testInvocation = null;
        this.synchronousButton.removeSelectionListener((SelectionListener)this);
        this.editButton.removeSelectionListener((SelectionListener)this);
        if (object instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)object).size() == 1) {
            object = iStructuredSelection.getFirstElement();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (object instanceof ITestInvocation) {
            this.testInvocation = (ITestInvocation)object;
            ITest iTest = this.testInvocation.getInvokedTest();
            bl = true;
            this.editButton.setEnabled(true);
            this.synchronousButton.setSelection(this.testInvocation.isSynchronous());
            this.synchronousButton.setEnabled(true);
            if (iTest != null) {
                IFile iFile;
                Object object2;
                bl2 = true;
                ImageDescriptor imageDescriptor = null;
                if (iTest instanceof IAdaptable && (object2 = (IWorkbenchAdapter)((IAdaptable)iTest).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestInvocationDetailPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                    imageDescriptor = object2.getImageDescriptor((Object)iTest);
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                this.imageLabel.setImage(imageDescriptor.createImage());
                if (iTest.getName() != null) {
                    this.testLink.setText(iTest.getName());
                } else {
                    this.testLink.setText(TestCommonPlugin.getString("W_TEST"));
                }
                this.testLink.setData((Object)iTest);
                object2 = iTest.getType();
                if (object2 != null) {
                    iFile = null;
                    if (iTest instanceof ITestSuite) {
                        iFile = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor((String)object2);
                    } else if (iTest instanceof ITestCase) {
                        iFile = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor((String)object2);
                    }
                    if (iFile != null && iFile.getName() != null) {
                        object2 = iFile.getName();
                    }
                    this.typeText.setText((String)object2);
                }
                if ((iFile = EMFUtil.getWorkspaceFile((EObject)((EObject)iTest))) != null) {
                    this.fileText.setText(iFile.getFullPath().toString());
                }
            }
        } else {
            this.editButton.setEnabled(false);
        }
        if (!bl2) {
            bl = true;
            this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
            this.testLink.setText(this.getDeftaultLinkText());
            this.testLink.setData(null);
            this.fileText.setText("");
            this.typeText.setText("");
            this.synchronousButton.setEnabled(false);
        }
        if (bl) {
            this.imageLabel.pack(true);
            this.imageLabel.redraw();
            this.testLink.pack(true);
            this.testLink.redraw();
        }
        this.editButton.addSelectionListener((SelectionListener)this);
        this.synchronousButton.addSelectionListener((SelectionListener)this);
    }

    public Object getInput() {
        return this.testInvocation;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        selectionEvent.doit = !this.isReadOnly();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.isReadOnly()) {
            selectionEvent.doit = false;
        } else if (selectionEvent.widget == this.editButton) {
            ITestSuite iTestSuite = (ITestSuite)EcoreUtil.getRootContainer((EObject)((EObject)this.testInvocation));
            InvokedTestSelectionDialog invokedTestSelectionDialog = this.createInvokedTestSelectionDialog(iTestSuite);
            invokedTestSelectionDialog.setTest((ITest)this.testLink.getData());
            if (invokedTestSelectionDialog.open() == 0) {
                ITest iTest = (ITest)invokedTestSelectionDialog.getTests().iterator().next();
                ResourceSet resourceSet = ((EObject)iTestSuite).eResource().getResourceSet();
                iTest = (ITest)EMFUtil.getEObject((ResourceSet)resourceSet, (EObject)((EObject)iTest), (boolean)true);
                if (this.testInvocation.getInvokedTest() != iTest) {
                    this.testInvocation.setInvokedTest(iTest);
                    this.setInput(this.testInvocation);
                }
            }
        } else if (selectionEvent.widget == this.synchronousButton) {
            this.testInvocation.setSynchronous(this.synchronousButton.getSelection());
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    protected abstract InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite var1);

    public void linkActivated(Control control) {
        EObject eObject;
        IFile iFile;
        Object object = control.getData();
        if (object != null && (iFile = EMFUtil.getWorkspaceFile((EObject)(eObject = (EObject)object))) != null) {
            IEditorPart iEditorPart = UIUtil.openEditor((IFile)iFile, null, (boolean)false);
            if (iEditorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)iEditorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        eObject = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        iFile = eObject.getStatusLineManager();
        if (iFile != null) {
            iFile.setErrorMessage(TestCommonPlugin.getString("MSG_UN_OPEN_OBJ"));
        }
    }

    public void linkEntered(Control control) {
        IActionBars iActionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager iStatusLineManager = iActionBars.getStatusLineManager();
        if (iStatusLineManager != null) {
            iStatusLineManager.setMessage(((SelectableFormLabel)control).getText());
        }
    }

    public void linkExited(Control control) {
        IActionBars iActionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager iStatusLineManager = iActionBars.getStatusLineManager();
        if (iStatusLineManager != null) {
            iStatusLineManager.setMessage("");
            iStatusLineManager.setErrorMessage("");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

