/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class RefreshFromLocalAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    private INavigator fViewer;

    public RefreshFromLocalAction(INavigator iNavigator) {
        super((ISelectionProvider)iNavigator.getViewer(), UIPlugin.getResourceString("RELOAD"));
        this.setDescription(UIPlugin.getResourceString("RELOAD_LOCAL_FILE"));
        this.fViewer = iNavigator;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".refl0000"));
        this.setToolTipText(UIPlugin.getResourceString("RELOAD_LOCAL_FILE_TOOLTIP"));
    }

    public void run() {
        String string = UIPlugin.getResourceString("TRACE_MSG");
        String string2 = UIPlugin.getResourceString("RELOAD_QUESTION");
        if (!MessageDialog.openQuestion((Shell)this.fViewer.getViewSite().getShell(), (String)string, (String)string2)) {
            return;
        }
        ProfileEvent profileEvent = new ProfileEvent();
        profileEvent.setSource(ResourcesPlugin.getWorkspace().getRoot());
        this.handleResources();
        profileEvent.setType(5120);
        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        if (!(this.fViewer instanceof PDProjectExplorer)) {
            profileEvent.setType(4608);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
    }

    private void handleResources() {
        PDContentProvider.resetMonitors();
        Object[] objectArray = HierarchyResourceSetImpl.getInstance().getResources().toArray();
        int n = 0;
        while (n < objectArray.length) {
            Resource resource = (Resource)objectArray[n];
            if (resource != null && resource.isLoaded()) {
                Object[] objectArray2 = resource.getContents().toArray();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    Object object = objectArray2[n2];
                    ArrayList arrayList = UIPlugin.getDefault().getDeleteListeners();
                    int n3 = 0;
                    while (n3 < arrayList.size()) {
                        ((IDeleteListener)arrayList.get(n3)).deregister(object);
                        ++n3;
                    }
                    resource.unload();
                    ++n2;
                }
            }
            ++n;
        }
    }
}

