/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TRCAgentEditor
extends EditorPart {
    TRCAgentProxy fAgent;

    public void createPartControl(Composite composite) {
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".agte0000"));
        TraceProcessUI traceProcessUI = new TraceProcessUI();
        traceProcessUI.createControl(composite);
        traceProcessUI.getLocationUI().setEnabled(false);
        traceProcessUI.getLaunchProcessUI().enable(false);
        traceProcessUI.getProcessIdUI().setEnabled(false);
        traceProcessUI.getNodeNameUI().setEnabled(false);
        if (this.fAgent != null) {
            TRCProcessProxy tRCProcessProxy = this.fAgent.getProcessProxy();
            TRCNode tRCNode = tRCProcessProxy.getNode();
            TRCMonitor tRCMonitor = tRCNode.getMonitor();
            Path path = new Path(TString.resourcePath(tRCMonitor.eResource().getURI()));
            traceProcessUI.getLocationUI().getLocation().setText(path.uptoSegment(path.segmentCount() - 1).toOSString());
            traceProcessUI.getLocationUI().getMonitor().setText(tRCMonitor.getName());
            String string = tRCProcessProxy.getName();
            traceProcessUI.getLaunchProcessUI().getClassUI().setText(string);
            traceProcessUI.getProcessIdUI().setText(String.valueOf(tRCProcessProxy.getPid()));
            traceProcessUI.getNodeNameUI().setText(tRCNode.getName());
            if (tRCProcessProxy.getClasspath() != null) {
                traceProcessUI.getLaunchProcessUI().getClassPathUI().setText(tRCProcessProxy.getClasspath());
            }
            if (tRCProcessProxy.getParameters() != null) {
                traceProcessUI.getLaunchProcessUI().getParametersUI().setText(tRCProcessProxy.getParameters());
            }
            if (tRCProcessProxy.getVmArguments() != null) {
                traceProcessUI.getLaunchProcessUI().getVMArgsUI().setText(tRCProcessProxy.getVmArguments());
            }
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (iEditorInput instanceof IFileEditorInput) {
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.setInput(iEditorInput);
            this.loadAgentDoc();
            if (this.fAgent != null) {
                this.setTitle(this.fAgent.getName() + "[" + this.fAgent.getProcessProxy().getName() + "]");
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    private TRCAgentProxy loadAgentDoc() {
        block4: {
            if (this.fAgent != null) break block4;
            try {
                String string = ((FileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
                ResourceSet resourceSet = UIPlugin.getDefault().getResourceSet();
                Resource resource = resourceSet.getResource(URI.createURI((String)("platform:/resource" + string)), true);
                if (resource == null) {
                    return this.fAgent;
                }
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof TRCAgentProxy)) continue;
                    this.fAgent = (TRCAgentProxy)e;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fAgent;
    }

    public void setFocus() {
    }
}

