/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProfileJavaApplicationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = this.performProfilingTypesLaunch(iLaunchConfiguration);
        if (!bl) {
            return;
        }
        ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        TraceArguments traceArguments = new TraceArguments(this.getMainTypeName(iLaunchConfiguration));
        traceArguments.setClassPath(this.getClasspathString(iLaunchConfiguration));
        traceArguments.setParameters(this.getProgramArguments(iLaunchConfiguration));
        traceArguments.setVMArguments(this.getVMArguments(iLaunchConfiguration));
        traceArguments.setEnvironmentVariable(profilingSetsManager.getEnvironmentVariables(iLaunchConfiguration));
        traceArguments.setAutoMonitoring(profilingSetsManager.getAutoMonitoring(iLaunchConfiguration));
        String string2 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
        int n = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, iPreferenceStore.getInt("localhost_port"));
        String string3 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, iPreferenceStore.getString("prj_name"));
        String string4 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, iPreferenceStore.getString("mon_name"));
        traceArguments.setHostName(string2);
        traceArguments.setPortNumber(n);
        if (iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
            traceArguments.setProfileFile(iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null));
        }
        ArrayList arrayList = profilingSetsManager.getFilters(iLaunchConfiguration);
        Vector vector = profilingSetsManager.getOptions(iLaunchConfiguration);
        PDCoreUtil.launchTrace(traceArguments, arrayList, vector, string3, string4, iLaunch);
    }

    protected boolean performProfilingTypesLaunch(ILaunchConfiguration iLaunchConfiguration) {
        IProfilingSetType[] iProfilingSetTypeArray;
        boolean bl = true;
        ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
        IProfilingSet iProfilingSet = null;
        try {
            iProfilingSetTypeArray = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, (String)null);
            iProfilingSet = (IProfilingSet)profilingSetsManager.getProfilingSets().get(iProfilingSetTypeArray);
        }
        catch (CoreException coreException) {
            HyadesUIPlugin.logError((Throwable)coreException);
        }
        if (iProfilingSet == null) {
            return true;
        }
        iProfilingSetTypeArray = new ProfilingSetType[profilingSetsManager.getProfilingTypes().size()];
        iProfilingSetTypeArray = profilingSetsManager.getProfilingTypes().values().toArray(iProfilingSetTypeArray);
        List list = iProfilingSet.getProfilingTypes();
        int n = 0;
        while (n < iProfilingSetTypeArray.length) {
            IProfilingType iProfilingType;
            String string;
            if (list.contains(iProfilingSetTypeArray[n].getId()) && (string = (iProfilingType = iProfilingSetTypeArray[n].getProfilingType()).launch(iLaunchConfiguration)) != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), (String)string);
                    }
                });
                return false;
            }
            ++n;
        }
        return true;
    }

    private String getClasspathString(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, (String)null);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = this.getClasspath(iLaunchConfiguration);
            int n = 0;
            while (n < stringArray.length - 1) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(File.pathSeparatorChar);
                ++n;
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            return stringBuffer.toString();
        }
        return string;
    }
}

