/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class ProfileRuntimeWorkbenchDelegate
implements ILaunchConfigurationDelegate,
ILauncherSettings {
    private static final String ECLIPSE_MAIN = "org.eclipse.core.launcher.Main";
    private static final String KEY_BAD_FEATURE_SETUP = "WorkbenchLauncherConfigurationDelegate.badFeatureSetup";
    private static final String KEY_NO_STARTUP = "WorkbenchLauncherConfigurationDelegate.noStartup";
    private File fConfigDir = null;

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask("", 3);
            String string2 = this.getWorkspace(iLaunchConfiguration);
            LauncherUtils.clearWorkspace((ILaunchConfiguration)iLaunchConfiguration, (String)string2);
            iProgressMonitor.worked(1);
            TraceArguments traceArguments = new TraceArguments(ECLIPSE_MAIN);
            traceArguments.setClassPath(this.getClassPath(iLaunchConfiguration));
            traceArguments.setParameters(this.getProgramArgs(iLaunchConfiguration));
            traceArguments.setVMArguments(this.getVMArgs(iLaunchConfiguration));
            traceArguments.setEnvironmentVariable(this.getEnvironment(iLaunchConfiguration));
            traceArguments.setAutoMonitoring(this.isAutoMonitoring(iLaunchConfiguration));
            traceArguments.setHostName(this.getHostName(iLaunchConfiguration));
            traceArguments.setPortNumber(this.getPortNumber(iLaunchConfiguration));
            traceArguments.setProfileFile(this.getProfileFile(iLaunchConfiguration));
            iProgressMonitor.worked(1);
            ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
            ArrayList arrayList = profilingSetsManager.getFilters(iLaunchConfiguration);
            Vector vector = profilingSetsManager.getOptions(iLaunchConfiguration);
            String string3 = this.getProjectName(iLaunchConfiguration);
            String string4 = this.getMonitorName(iLaunchConfiguration);
            iProgressMonitor.worked(1);
            PDCoreUtil.launchTrace(traceArguments, arrayList, vector, string3, string4, iLaunch);
        }
        catch (CoreException coreException) {
            iProgressMonitor.setCanceled(true);
            throw coreException;
        }
    }

    private boolean isAutoMonitoring(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
    }

    private String getHostName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
    }

    private int getPortNumber(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        return iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, iPreferenceStore.getInt("localhost_port"));
    }

    private String getProjectName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        return iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, iPreferenceStore.getString("prj_name"));
    }

    private String getMonitorName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        return iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, iPreferenceStore.getString("mon_name"));
    }

    private String getWorkspace(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
    }

    private String getProfileFile(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
            return iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null);
        }
        return null;
    }

    private ArrayList getEnvironment(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String[] stringArray = DebugPlugin.getDefault().getLaunchManager().getEnvironment(iLaunchConfiguration);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        return arrayList;
    }

    private String getClassPath(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String[] stringArray = LauncherUtils.constructClasspath((ILaunchConfiguration)iLaunchConfiguration);
        if (stringArray == null) {
            String string = PDEPlugin.getResourceString((String)KEY_NO_STARTUP);
            throw new CoreException(LauncherUtils.createErrorStatus((String)string));
        }
        if (stringArray.length == 0) {
            return null;
        }
        String string = "";
        int n = 0;
        while (n < stringArray.length - 1) {
            string = string + stringArray[n] + File.pathSeparatorChar;
            ++n;
        }
        string = string + stringArray[stringArray.length - 1];
        return string;
    }

    private String getVMArgs(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String[] stringArray = new ExecutionArguments(iLaunchConfiguration.getAttribute("vmargs", ""), "").getVMArgumentsArray();
        if (stringArray.length == 0) {
            return null;
        }
        String string = "";
        int n = 0;
        while (n < stringArray.length - 1) {
            string = string + stringArray[n] + " ";
            ++n;
        }
        string = string + stringArray[stringArray.length - 1];
        return string;
    }

    private String getProgramArgs(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String[] stringArray = this.getProgramArguments(iLaunchConfiguration);
        if (stringArray.length == 0) {
            return null;
        }
        String string = "";
        int n = 0;
        while (n < stringArray.length - 1) {
            string = string + stringArray[n] + " ";
            ++n;
        }
        string = string + stringArray[stringArray.length - 1];
        return string;
    }

    private String[] getProgramArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = iLaunchConfiguration.getAttribute("application", (String)null);
        if (string != null && string.length() > 0) {
            arrayList.add("-application");
            arrayList.add(string);
        }
        String string2 = iLaunchConfiguration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
        arrayList.add("-data");
        arrayList.add(string2);
        boolean bl = PDECore.getDefault().getModelManager().isOSGiRuntime();
        if (iLaunchConfiguration.getAttribute("usefeatures", false)) {
            this.validateFeatures();
            object2 = PDEPlugin.getWorkspace().getRoot().getLocation();
            arrayList.add("-install");
            arrayList.add("file:" + object2.removeLastSegments(1).addTrailingSeparator().toString());
            arrayList.add("-update");
        } else {
            object2 = LauncherUtils.getPluginsToRun((ILaunchConfiguration)iLaunchConfiguration);
            if (object2 == null) {
                return null;
            }
            object = LauncherUtils.getPrimaryFeatureId();
            TargetPlatform.createPlatformConfigurationArea((TreeMap)object2, (File)this.getConfigDir(iLaunchConfiguration), (String)object, (HashMap)LauncherUtils.getAutoStartPlugins((ILaunchConfiguration)iLaunchConfiguration));
            arrayList.add("-configuration");
            if (bl) {
                arrayList.add("file:" + new Path(this.getConfigDir(iLaunchConfiguration).getPath()).addTrailingSeparator().toString());
            } else {
                arrayList.add("file:" + new Path(this.getConfigDir(iLaunchConfiguration).getPath()).append("platform.cfg").toString());
            }
            if (!bl) {
                IPluginModelBase iPluginModelBase;
                String string3;
                if (object != null) {
                    arrayList.add("-feature");
                    arrayList.add((String)object);
                }
                if ((string3 = LauncherUtils.getBootPath((IPluginModelBase)(iPluginModelBase = (IPluginModelBase)((TreeMap)object2).get("org.eclipse.core.boot")))) != null && !string3.endsWith(".jar")) {
                    arrayList.add("-boot");
                    arrayList.add("file:" + string3);
                }
            }
        }
        arrayList.add("-dev");
        object2 = LauncherUtils.getBuildOutputFolders();
        arrayList.add(iLaunchConfiguration.getAttribute("classpath", (String)object2));
        if (iLaunchConfiguration.getAttribute("tracing", false) && !"[NONE]".equals(iLaunchConfiguration.getAttribute("checked", (String)null))) {
            arrayList.add("-debug");
            arrayList.add(LauncherUtils.getTracingFileArgument((ILaunchConfiguration)iLaunchConfiguration, (String)(this.getConfigDir(iLaunchConfiguration).toString() + '/' + ".options")));
        }
        object = new StringTokenizer(iLaunchConfiguration.getAttribute("progargs", ""));
        while (((StringTokenizer)object).hasMoreTokens()) {
            arrayList.add(((StringTokenizer)object).nextToken());
        }
        boolean bl2 = true;
        int n = arrayList.indexOf("-application");
        if (n != -1 && n <= arrayList.size() - 2 && !arrayList.get(n + 1).equals(LauncherUtils.getDefaultApplicationName())) {
            bl2 = false;
        }
        if (bl2 && !arrayList.contains("-nosplash")) {
            arrayList.add(0, "-showsplash");
            arrayList.add(1, this.computeShowsplashArgument());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getVMArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return new ExecutionArguments(iLaunchConfiguration.getAttribute("vmargs", ""), "").getVMArgumentsArray();
    }

    private void validateFeatures() throws CoreException {
        boolean bl;
        IPath iPath = PDEPlugin.getWorkspace().getRoot().getLocation();
        String string = iPath.lastSegment();
        boolean bl2 = bl = string == null;
        if (!bl) {
            IPath iPath2 = iPath.removeLastSegments(1).append("features");
            boolean bl3 = bl = !string.equalsIgnoreCase("plugins") || !iPath2.toFile().exists();
        }
        if (bl) {
            throw new CoreException(LauncherUtils.createErrorStatus((String)PDEPlugin.getResourceString((String)KEY_BAD_FEATURE_SETUP)));
        }
        this.ensureProductFilesExist(this.getProductPath());
    }

    private IPath getInstallPath() {
        return PDEPlugin.getWorkspace().getRoot().getLocation();
    }

    private IPath getProductPath() {
        return this.getInstallPath().removeLastSegments(1);
    }

    private String computeShowsplashArgument() {
        IPath iPath = ExternalModelManager.getEclipseHome();
        IPath iPath2 = iPath.append("eclipse");
        return iPath2.toOSString() + " -showsplash 600";
    }

    private void ensureProductFilesExist(IPath iPath) {
        File file = iPath.toFile();
        File file2 = new File(file, ".eclipseproduct");
        IPath iPath2 = ExternalModelManager.getEclipseHome();
        if (!file2.exists()) {
            this.copyFile(iPath2, ".eclipseproduct", file2);
        }
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            File file3;
            File file4 = new File(file, "configuration");
            if (!file4.exists()) {
                file4.mkdirs();
            }
            if (!(file3 = new File(file4, "config.ini")).exists()) {
                this.copyFile(iPath2.append("configuration"), "config.ini", file3);
            }
        } else {
            File file5 = new File(file, "install.ini");
            if (!file5.exists()) {
                this.copyFile(iPath2, "install.ini", file5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(IPath iPath, String string, File file) {
        File file2 = new File(iPath.toFile(), string);
        if (!file2.exists()) {
            return;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            long l = 0L;
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                l += (long)n;
                fileOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File getConfigDir(ILaunchConfiguration iLaunchConfiguration) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LauncherUtils.createConfigArea((String)iLaunchConfiguration.getName());
        }
        return this.fConfigDir;
    }
}

