/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProfilingSetsManager {
    protected static ProfilingSetsManager instance;
    protected Map profilingSets;
    protected Map profilingTypesGroups;
    protected Map profilingTypes;
    protected Map filterSets;
    protected IProfilingSet defaultSet = null;
    protected FilterSetElement defaultFilterSet = null;
    protected final String profilingTypesGroupsExtPoint = "profilingTypesGroups";
    protected final String profilingTypesExtPoint = "profilingTypes";
    protected final String profilingSetsExtPoint = "profilingSets";
    protected final String profilingSetsStore = "profilingTypeSets";
    protected final String defaultProfilingSet = "defaultProfilingSet";

    protected ProfilingSetsManager() {
    }

    public static ProfilingSetsManager instance() {
        if (instance == null) {
            instance = new ProfilingSetsManager();
        }
        return instance;
    }

    public Map getProfilingTypesGroups() {
        if (this.profilingTypesGroups == null) {
            this.initialize();
        }
        return this.profilingTypesGroups;
    }

    public Map getProfilingTypes() {
        if (this.profilingTypes == null) {
            this.initialize();
        }
        return this.profilingTypes;
    }

    public Map getProfilingSets() {
        if (this.profilingSets == null) {
            this.initialize();
        }
        return this.profilingSets;
    }

    protected void initialize() {
        this.initializeProfilingTypesGroups();
        this.initializeProfilingTypes();
        this.initializeProfilingSets();
        this.initializeProfilingFilters();
    }

    protected void initializeProfilingTypesGroups() {
        this.profilingTypesGroups = new HashMap();
        IExtensionPoint iExtensionPoint = UIPlugin.getDefault().getDescriptor().getExtensionPoint("profilingTypesGroups");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string2 = iConfigurationElement.getAttribute("name");
                String string3 = iConfigurationElement.getAttribute("id");
                String string4 = iConfigurationElement.getAttribute("icon");
                String string5 = UIPlugin.getResourceString("DEFAULT_PROFILING_GROUP_DESCRIPTION");
                String[] stringArray = iConfigurationElement.getAttributeNames();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equalsIgnoreCase("description") && (string = iConfigurationElement.getAttribute("description")).length() > 0) {
                        string5 = string;
                    }
                    ++n2;
                }
                if (string3 != null && string2 != null) {
                    string = null;
                    if (string4 != null) {
                        try {
                            string = ImageDescriptor.createFromURL((URL)new URL(iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL() + string4));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    this.profilingTypesGroups.put(string3, new ProfilingSetTypeGroup(string3, string2, string5, (ImageDescriptor)string));
                }
                ++n;
            }
        }
    }

    protected void initializeProfilingTypes() {
        this.profilingTypes = new HashMap();
        IExtensionPoint iExtensionPoint = UIPlugin.getDefault().getDescriptor().getExtensionPoint("profilingTypes");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string = iConfigurationElement.getAttribute("id");
                String string2 = iConfigurationElement.getAttribute("name");
                if (string != null && string2 != null) {
                    String string3 = iConfigurationElement.getAttribute("icon");
                    ImageDescriptor imageDescriptor = null;
                    if (string3 != null) {
                        try {
                            imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL() + string3));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    String string4 = iConfigurationElement.getAttribute("description");
                    String string5 = iConfigurationElement.getAttribute("group");
                    boolean bl = iConfigurationElement.getAttribute("useFilters") == null ? false : iConfigurationElement.getAttribute("useFilters").equalsIgnoreCase("true");
                    IProfilingType iProfilingType = null;
                    try {
                        iProfilingType = (IProfilingType)iConfigurationElement.createExecutableExtension("className");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (iProfilingType != null) {
                        ProfilingSetType profilingSetType = new ProfilingSetType(string, string2, string4, imageDescriptor, bl, string5, iProfilingType);
                        this.profilingTypes.put(string, profilingSetType);
                    }
                }
                ++n;
            }
        }
    }

    protected void initializeProfilingSets() {
        this.profilingSets = new HashMap();
        this.readSetsFromRegistry();
        this.readSetsFromPreferences("profilingTypeSets", "defaultProfilingSet");
        if (this.getDefaultSet() == null && this.profilingSets.size() > 0) {
            Object[] objectArray = this.profilingSets.values().toArray();
            int n = 0;
            while (n < this.profilingSets.values().size()) {
                IProfilingSet iProfilingSet = (IProfilingSet)objectArray[n];
                if (iProfilingSet.getId().equals(this.getDefaultProfilingSet())) {
                    this.setDefaultSet(iProfilingSet);
                }
                ++n;
            }
        }
    }

    protected void readSetsFromRegistry() {
        IExtensionPoint iExtensionPoint = UIPlugin.getDefault().getDescriptor().getExtensionPoint("profilingSets");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string = iConfigurationElement.getAttribute("id");
                String string2 = iConfigurationElement.getAttribute("name");
                String string3 = iConfigurationElement.getAttribute("description");
                if (string != null && string2 != null) {
                    ProfilingAttribute profilingAttribute;
                    Object object;
                    IConfigurationElement[] iConfigurationElementArray2;
                    ProfilingSet profilingSet = new ProfilingSet(string, string2, string3);
                    IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement.getChildren("profilingTypes");
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray3.length) {
                        iConfigurationElementArray2 = iConfigurationElementArray3[n2].getChildren("profilingType");
                        int n3 = 0;
                        while (n3 < iConfigurationElementArray2.length) {
                            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n3];
                            object = iConfigurationElement2.getAttribute("id");
                            if (object != null) {
                                profilingSet.getProfilingTypes().add(object);
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    iConfigurationElementArray2 = iConfigurationElement.getChildren("attributes");
                    List list = ProfilingSetsManager.getDefaultProfilingOptions();
                    int n4 = 0;
                    while (n4 < iConfigurationElementArray2.length) {
                        object = iConfigurationElementArray2[n4].getChildren("attribute");
                        int n5 = 0;
                        while (n5 < ((IConfigurationElement[])object).length) {
                            profilingAttribute = object[n5];
                            String string4 = profilingAttribute.getAttribute("type");
                            String string5 = profilingAttribute.getAttribute("name");
                            String string6 = profilingAttribute.getAttribute("value");
                            if (string4 != null && string5 != null && string6 != null) {
                                string5 = "ATTR".equals(string4) ? UIPlugin.getPluginId() + ".ATTR_" + string5 : string4 + "_" + string5;
                                ProfilingAttribute profilingAttribute2 = new ProfilingAttribute(string5, string6);
                                list.add(profilingAttribute2);
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    object = profilingSet.getAttributes();
                    Iterator iterator = ProfilingSetsManager.filterDuplicateOptions(list).iterator();
                    while (iterator.hasNext()) {
                        profilingAttribute = (ProfilingAttribute)iterator.next();
                        object.put(profilingAttribute.getName(), profilingAttribute);
                    }
                    this.profilingSets.put(string, profilingSet);
                }
                ++n;
            }
        }
    }

    protected void readSetsFromPreferences(String string, String string2) {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        String string3 = iPreferenceStore.getString(string);
        String string4 = iPreferenceStore.getString(string2);
        if (string3 == null || string3.length() == 0) {
            return;
        }
        this.readSets(string3, string4);
    }

    protected void readSets(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return;
        }
        Element element = XMLUtil.loadDom((String)string, (String)"profilingSets");
        NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"profilingSet");
        Element element2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                element2 = (Element)nodeList.item(n);
            }
            object = element2.getAttribute("name");
            String string3 = element2.getAttribute("description");
            String string4 = element2.getAttribute("id");
            if (string4 != null) {
                Object object2;
                Object object3;
                int n2;
                NodeList nodeList2;
                Object object4;
                IProfilingSet iProfilingSet;
                Object v = this.profilingSets.get(string4);
                if (v == null) {
                    iProfilingSet = new ProfilingSet(string4, (String)object, string3);
                    this.profilingSets.put(string4, iProfilingSet);
                } else {
                    iProfilingSet = (IProfilingSet)v;
                    iProfilingSet.setName((String)object);
                    iProfilingSet.setDescription(string3);
                    iProfilingSet.getAttributes().clear();
                    iProfilingSet.getProfilingTypes().clear();
                }
                NodeList nodeList3 = XMLUtil.getChildrenByName((Element)element2, (String)"profilingTypes");
                int n3 = 0;
                while (n3 < nodeList3.getLength()) {
                    object4 = (Element)nodeList3.item(n3);
                    nodeList2 = XMLUtil.getChildrenByName((Element)object4, (String)"profilingType");
                    n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        object3 = (Element)nodeList2.item(n2);
                        object2 = object3.getAttribute("name");
                        if (object2 != null && ((String)object2).length() > 0) {
                            iProfilingSet.getProfilingTypes().add(object2);
                        }
                        ++n2;
                    }
                    ++n3;
                }
                object4 = ProfilingSetsManager.getDefaultProfilingOptions();
                nodeList2 = XMLUtil.getChildrenByName((Element)element2, (String)"attributes");
                n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    object3 = (Element)nodeList2.item(n2);
                    object2 = XMLUtil.getChildrenByName((Element)object3, (String)"attribute");
                    int n4 = 0;
                    while (n4 < object2.getLength()) {
                        Element element3 = (Element)object2.item(n4);
                        String string5 = element3.getAttribute("type");
                        String string6 = element3.getAttribute("name");
                        String string7 = element3.getAttribute("value");
                        if (string5.length() > 0) {
                            string6 = string5 + "_" + string6;
                        }
                        ProfilingAttribute profilingAttribute = new ProfilingAttribute(string6, string7);
                        object4.add(profilingAttribute);
                        ++n4;
                    }
                    ++n2;
                }
                object3 = ProfilingSetsManager.filterDuplicateOptions((List)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (ProfilingAttribute)object3.next();
                    iProfilingSet.getAttributes().put(((ProfilingAttribute)object2).getName(), object2);
                }
            }
            ++n;
        }
        if (string2 != null && (object = this.getProfilingSets().get(string2)) != null) {
            this.setDefaultSet((IProfilingSet)object);
        }
        if (this.getDefaultSet() == null && this.profilingSets.size() > 0) {
            object = this.profilingSets.values().toArray();
            this.setDefaultSet((IProfilingSet)object[0]);
        }
    }

    protected void readFilters(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Element element = XMLUtil.loadDom((String)string, (String)"filters");
        NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"filter");
        Element element2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            FilterSetElement filterSetElement;
            String string2;
            Object v;
            if (nodeList.item(n) instanceof Element) {
                element2 = (Element)nodeList.item(n);
            }
            if ((v = this.filterSets.get(string2 = element2.getAttribute("name"))) == null) {
                filterSetElement = new FilterSetElement(string2);
                this.filterSets.put(string2, filterSetElement);
            } else {
                filterSetElement = (FilterSetElement)v;
                filterSetElement.setName(string2);
                filterSetElement.getChildren().clear();
            }
            ArrayList<FilterTableElement> arrayList = new ArrayList<FilterTableElement>();
            NodeList nodeList2 = XMLUtil.getChildrenByName((Element)element2, (String)"contents");
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                Element element3 = (Element)nodeList2.item(n2);
                NodeList nodeList3 = XMLUtil.getChildrenByName((Element)element3, (String)"content");
                int n3 = 0;
                while (n3 < nodeList3.getLength()) {
                    Element element4 = (Element)nodeList3.item(n3);
                    String string3 = element4.getAttribute("text");
                    String string4 = element4.getAttribute("method");
                    String string5 = element4.getAttribute("visibility");
                    string5 = string5.equals("0") || string5.equals("EXCLUDE") ? "EXCLUDE" : "INCLUDE";
                    FilterTableElement filterTableElement = new FilterTableElement(string3, string4, string5);
                    arrayList.add(filterTableElement);
                    ++n3;
                }
                ++n2;
            }
            filterSetElement.setChildren(arrayList);
            ++n;
        }
    }

    public void writeSetsToPreferences() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("profilingTypeSets", this.getProfilingSetsString().toString());
        iPreferenceStore.setValue("set_filters", this.getProfilingFiltersString().toString());
        if (this.getDefaultSet() != null) {
            iPreferenceStore.setValue("defaultProfilingSet", this.getDefaultSet().getId());
        }
    }

    protected StringBuffer getProfilingSetsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml");
        stringBuffer.append(XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append(XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
        stringBuffer.append("?>");
        stringBuffer.append("<profilingSets>");
        Iterator iterator = this.getProfilingSets().keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            IProfilingSet iProfilingSet = (IProfilingSet)this.profilingSets.get(k);
            stringBuffer.append("<profilingSet");
            stringBuffer.append(XMLUtil.createXMLAttribute((String)"id", (String)iProfilingSet.getId(), (boolean)false));
            stringBuffer.append(XMLUtil.createXMLAttribute((String)"name", (String)iProfilingSet.getName(), (boolean)false));
            stringBuffer.append(XMLUtil.createXMLAttribute((String)"description", (String)iProfilingSet.getDescription(), (boolean)false));
            stringBuffer.append(">");
            stringBuffer.append("<profilingTypes>");
            List list = iProfilingSet.getProfilingTypes();
            int n = 0;
            while (n < list.size()) {
                stringBuffer.append("<profilingType");
                stringBuffer.append(XMLUtil.createXMLAttribute((String)"name", (String)list.get(n).toString(), (boolean)false));
                stringBuffer.append("/>");
                ++n;
            }
            stringBuffer.append("</profilingTypes>");
            stringBuffer.append("<attributes>");
            Iterator iterator2 = iProfilingSet.getAttributes().keySet().iterator();
            while (iterator2.hasNext()) {
                Object k2 = iterator2.next();
                ProfilingAttribute profilingAttribute = (ProfilingAttribute)iProfilingSet.getAttributes().get(k2);
                stringBuffer.append("<attribute");
                stringBuffer.append(XMLUtil.createXMLAttribute((String)"name", (String)profilingAttribute.getName(), (boolean)false));
                stringBuffer.append(XMLUtil.createXMLAttribute((String)"value", (String)profilingAttribute.getValue(), (boolean)false));
                stringBuffer.append("/>");
            }
            stringBuffer.append("</attributes>");
            stringBuffer.append("</profilingSet>");
        }
        stringBuffer.append("</profilingSets>");
        return stringBuffer;
    }

    protected StringBuffer getProfilingFiltersString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml");
        stringBuffer.append(XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append(XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
        stringBuffer.append("?>");
        stringBuffer.append("<filters>");
        Iterator iterator = this.getFilterSets().keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            FilterSetElement filterSetElement = (FilterSetElement)this.filterSets.get(k);
            stringBuffer.append("<filter");
            stringBuffer.append(XMLUtil.createXMLAttribute((String)"name", (String)filterSetElement.getName(), (boolean)false));
            stringBuffer.append(">");
            stringBuffer.append("<contents>");
            ArrayList arrayList = filterSetElement.getChildren();
            int n = 0;
            while (n < arrayList.size()) {
                FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
                stringBuffer.append("<content");
                stringBuffer.append(XMLUtil.createXMLAttribute((String)"text", (String)filterTableElement.getText(), (boolean)false));
                stringBuffer.append(XMLUtil.createXMLAttribute((String)"method", (String)filterTableElement.getMethod(), (boolean)false));
                stringBuffer.append(XMLUtil.createXMLAttribute((String)"visibility", (String)filterTableElement.getVisibility(), (boolean)false));
                stringBuffer.append("/>");
                ++n;
            }
            stringBuffer.append("</contents>");
            stringBuffer.append("</filter>");
        }
        stringBuffer.append("</filters>");
        return stringBuffer;
    }

    public IProfilingSetType[] getProfilingTypesForGroup(String string) {
        Object object;
        if (string == null) {
            return new IProfilingSetType[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getProfilingTypes().values().iterator();
        while (iterator.hasNext()) {
            object = (IProfilingSetType)iterator.next();
            if (!object.getGroup().equals(string)) continue;
            arrayList.add(object);
        }
        object = new IProfilingSetType[arrayList.size()];
        return (IProfilingSetType[])arrayList.toArray((T[])object);
    }

    public IProfilingSet getDefaultSet() {
        if (this.profilingSets == null) {
            this.initialize();
        }
        return this.defaultSet;
    }

    public void setDefaultSet(IProfilingSet iProfilingSet) {
        this.defaultSet = iProfilingSet;
    }

    protected void initializeProfilingFilters() {
        this.filterSets = new HashMap();
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("set_filters");
        this.readFilters(string);
        if (this.getDefaultFilterSet() == null && this.filterSets.size() > 0) {
            FilterSetElement filterSetElement = (FilterSetElement)this.filterSets.get(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"));
            if (filterSetElement != null) {
                this.setDefaultFilterSet(filterSetElement);
            } else {
                Object[] objectArray = this.filterSets.values().toArray();
                this.setDefaultFilterSet((FilterSetElement)objectArray[0]);
            }
        }
    }

    public Map getFilterSets() {
        if (this.filterSets == null) {
            this.initialize();
        }
        return this.filterSets;
    }

    public void setFilterSets(Map map) {
        this.filterSets = map;
    }

    public FilterSetElement getDefaultFilterSet() {
        if (this.profilingSets == null) {
            this.initialize();
        }
        return this.defaultFilterSet;
    }

    public void setDefaultFilterSet(FilterSetElement filterSetElement) {
        this.defaultFilterSet = filterSetElement;
    }

    public Vector getLimitOptions(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        Vector<AgentConfigurationEntry> vector = new Vector<AgentConfigurationEntry>();
        boolean bl = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, iPreferenceStore.getBoolean("limitInvoc"));
        int n = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, iPreferenceStore.getInt("invoc_nb"));
        boolean bl2 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, iPreferenceStore.getBoolean("limitTime"));
        int n2 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, iPreferenceStore.getInt("timeSec"));
        if (bl) {
            AgentConfigurationEntry agentConfigurationEntry;
            AgentConfigurationEntry agentConfigurationEntry2 = new AgentConfigurationEntry();
            agentConfigurationEntry2.setName("BURST_MODE");
            agentConfigurationEntry2.setType("SETOPTION");
            if (bl2) {
                agentConfigurationEntry2.setValue("secondsAndInvocations");
                agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName("BURST_SECONDS");
                agentConfigurationEntry.setValue(String.valueOf(n2));
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
            } else {
                agentConfigurationEntry2.setValue("invocations");
            }
            vector.addElement(agentConfigurationEntry2);
            agentConfigurationEntry = new AgentConfigurationEntry();
            agentConfigurationEntry.setName("BURST_INVOCATIONS");
            agentConfigurationEntry.setValue(String.valueOf(n));
            agentConfigurationEntry.setType("SETOPTION");
            vector.addElement(agentConfigurationEntry);
        } else if (bl2) {
            AgentConfigurationEntry agentConfigurationEntry = new AgentConfigurationEntry();
            agentConfigurationEntry.setName("BURST_MODE");
            agentConfigurationEntry.setType("SETOPTION");
            agentConfigurationEntry.setValue("seconds");
            vector.addElement(agentConfigurationEntry);
            agentConfigurationEntry = new AgentConfigurationEntry();
            agentConfigurationEntry.setName("BURST_SECONDS");
            agentConfigurationEntry.setValue(String.valueOf(n2));
            agentConfigurationEntry.setType("SETOPTION");
            vector.addElement(agentConfigurationEntry);
        }
        return vector;
    }

    public Vector getOptions(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        Vector vector = this.getProfileOptions(iLaunchConfiguration);
        Vector vector2 = this.getLimitOptions(iLaunchConfiguration);
        vector.addAll(vector2);
        return vector;
    }

    public Vector getProfileOptions(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        List list;
        Object object;
        Object object2;
        Object object3;
        Vector<Object> vector = new Vector<Object>();
        Map map = iLaunchConfiguration.getAttributes();
        Iterator iterator = map.keySet().iterator();
        String string = "SETOPTION_";
        int n = 0;
        while (iterator.hasNext()) {
            object3 = iterator.next().toString();
            if (((String)object3).startsWith(string)) {
                object2 = new AgentConfigurationEntry();
                object2.setName(((String)object3).substring(string.length()));
                object2.setValue(map.get(object3).toString());
                object2.setType("SETOPTION");
                vector.addElement(object2);
                ++n;
                continue;
            }
            if (this.filterOption((String)object3)) continue;
            object2 = new AgentConfigurationEntry();
            object2.setName((String)object3);
            object2.setValue(map.get(object3).toString());
            object2.setType("SETOPTION");
            vector.addElement(object2);
        }
        if (n == 0) {
            object3 = this.getDefaultSet();
            object2 = object3.getAttributes().values().iterator();
            while (object2.hasNext()) {
                object = (ProfilingAttribute)object2.next();
                if (!((ProfilingAttribute)object).getName().startsWith(string)) continue;
                list = new AgentConfigurationEntry();
                list.setName(((ProfilingAttribute)object).getName().substring(string.length()));
                list.setValue(((ProfilingAttribute)object).getValue());
                list.setType("SETOPTION");
                vector.addElement(list);
            }
        }
        if ((object3 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, (String)null)) != null && (object2 = this.getProfilingSets()) != null && (object = (IProfilingSet)object2.get(object3)) != null && (list = object.getProfilingTypes()) != null) {
            int n2 = 0;
            while (n2 < list.size()) {
                AgentConfigurationEntry agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setName(UIPlugin.getPluginId() + ".type" + n2);
                agentConfigurationEntry.setValue((String)list.get(n2));
                agentConfigurationEntry.setType("SETOPTION");
                vector.addElement(agentConfigurationEntry);
                ++n2;
            }
        }
        return vector;
    }

    protected boolean filterOption(String string) {
        return string.equals(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET) || string.equals(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET);
    }

    public boolean getAutoMonitoring(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
    }

    public ArrayList getEnvironmentVariables(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ArrayList<EnvTableElement> arrayList = new ArrayList<EnvTableElement>();
        Map map = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_ENVIRONMENT_VARIABLES, (Map)null);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                arrayList.add(new EnvTableElement(string, (String)map.get(string)));
            }
        }
        return arrayList;
    }

    public ArrayList getFilters(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, this.getDefaultFilterSet().getName());
        FilterSetElement filterSetElement = (FilterSetElement)this.getFilterSets().get(string);
        if (filterSetElement == null) {
            return new ArrayList(0);
        }
        return filterSetElement.getChildren();
    }

    private String getDefaultFilterSetAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        FilterSetElement filterSetElement = this.getDefaultFilterSet();
        ArrayList arrayList = filterSetElement.getChildren();
        int n = 0;
        while (n < arrayList.size()) {
            FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
            stringBuffer.append(filterTableElement.getText());
            if (filterTableElement.getMethod().length() > 0) {
                stringBuffer.append(":").append(filterTableElement.getMethod());
            }
            stringBuffer.append(":").append(filterTableElement.getVisibility());
            stringBuffer.append("&");
            ++n;
        }
        return stringBuffer.toString();
    }

    private FilterTableElement getFilterElement(String string) {
        Object object;
        String string2 = string;
        String string3 = "*";
        int n = string2.indexOf(":");
        if (n != -1) {
            string2 = string2.substring(0, n);
            string3 = string.substring(n + 1);
        }
        n = string3.indexOf(":");
        String string4 = "EXCLUDE";
        if (n != -1) {
            object = string3;
            string3 = string3.substring(0, n);
            string4 = ((String)object).substring(n + 1);
        }
        object = new FilterTableElement(string2, string3, string4);
        return object;
    }

    public String getDefaultProfilingSet() {
        return "org.eclipse.hyades.defaultProfilingSets.memory";
    }

    public static List getDefaultProfilingOptions() {
        ArrayList<ProfilingAttribute> arrayList = new ArrayList<ProfilingAttribute>();
        String[][] stringArray = Options.OPTIONS_DEFAULT;
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(new ProfilingAttribute("SETOPTION_" + stringArray[n][0], stringArray[n][1]));
            ++n;
        }
        return arrayList;
    }

    public static List filterDuplicateOptions(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProfilingSetsManager.addProfilingOption(arrayList, (ProfilingAttribute)iterator.next());
        }
        return arrayList;
    }

    public static void addProfilingOption(List list, ProfilingAttribute profilingAttribute) {
        int n = 0;
        while (n < list.size()) {
            ProfilingAttribute profilingAttribute2 = (ProfilingAttribute)list.get(n);
            if (profilingAttribute2.getName().equals(profilingAttribute.getName())) {
                if (profilingAttribute2.getValue().equals("false")) {
                    profilingAttribute2.setValue(profilingAttribute.getValue());
                } else if (profilingAttribute2.getValue().equals("none")) {
                    profilingAttribute2.setValue(profilingAttribute.getValue());
                } else {
                    if (profilingAttribute.getValue().equals("false")) {
                        return;
                    }
                    if (profilingAttribute2.getValue().equals("none")) {
                        return;
                    }
                    if (profilingAttribute2.getName().equals("SETOPTION_STACK_INFORMATION")) {
                        if (profilingAttribute2.getValue().equals("boundary")) {
                            return;
                        }
                        if (!profilingAttribute.getValue().equals("none")) {
                            profilingAttribute2.setValue(profilingAttribute.getValue());
                        }
                    } else if (profilingAttribute2.getName().equals("SETOPTION_TRACE_MODE") && profilingAttribute2.getValue().equals("noObjectCorrelation")) {
                        profilingAttribute2.setValue(profilingAttribute.getValue());
                    }
                }
                return;
            }
            ++n;
        }
        list.add(profilingAttribute);
    }
}

