/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CTree {
    protected ArrayList fAgentTypeList;
    protected Label _label;
    protected Tree _tree;
    protected Composite groupWidget;

    public CTree(Composite composite, String string) {
        this.groupWidget = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.groupWidget.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 200;
        gridData.widthHint = 250;
        this.groupWidget.setLayoutData((Object)gridData);
        this._label = new Label(this.groupWidget, 0);
        this._label.setText(string);
        this._tree = new Tree(this.groupWidget, 2818);
    }

    public TreeItem addItem(TreeItem treeItem, boolean bl) {
        if (treeItem.getParentItem() != null) {
            TreeItem treeItem2;
            TreeItem treeItem3 = this.getItem(treeItem.getParentItem().getData());
            if (treeItem3 == null) {
                treeItem3 = new TreeItem(this._tree, 0);
                this.setItemData(treeItem3, treeItem.getParentItem().getData());
            }
            if ((treeItem2 = this.getItem(treeItem3, treeItem.getText())) == null) {
                treeItem2 = new TreeItem(treeItem3, 0);
                this.setItemData(treeItem2, treeItem.getData());
            }
            if (bl) {
                this._tree.setSelection(new TreeItem[]{treeItem2});
            }
            return treeItem3;
        }
        TreeItem treeItem4 = this.getItemEntry(treeItem);
        if (treeItem4 == null) {
            treeItem4 = new TreeItem(this._tree, 0);
            this.setItemData(treeItem4, treeItem.getData());
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem treeItem5 = this.getItem(treeItem4, treeItemArray[n].getText());
            if (treeItem5 == null) {
                treeItem5 = new TreeItem(treeItem4, 0);
                this.setItemData(treeItem5, treeItemArray[n].getData());
            }
            ++n;
        }
        if (bl) {
            this._tree.setSelection(new TreeItem[]{treeItem4});
        }
        return treeItem4;
    }

    public void clearSelection() {
        this._tree.deselectAll();
    }

    public boolean contains(String string) {
        TreeItem[] treeItemArray = this._tree.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n].getData().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public TreeItem createItem(TreeItem treeItem, Object object, boolean bl) {
        TreeItem treeItem2 = null;
        if (treeItem == null) {
            String string = ((Process)object).getName();
            if (string == null) {
                string = ((Process)object).getExecutable();
            }
            if ((treeItem2 = this.getItem(string)) == null) {
                treeItem2 = new TreeItem(this._tree, 0);
            }
        } else {
            treeItem2 = new TreeItem(treeItem, 0);
        }
        this.setItemData(treeItem2, object);
        return treeItem2;
    }

    public void enable(boolean bl) {
        this._tree.setEnabled(bl);
        this._label.setEnabled(bl);
    }

    public int getItemCount() {
        if (this._tree != null) {
            return this._tree.getItemCount();
        }
        return 0;
    }

    public TreeItem getItem(int n) {
        TreeItem[] treeItemArray = this._tree.getItems();
        if (n < treeItemArray.length) {
            return treeItemArray[n];
        }
        return null;
    }

    protected TreeItem getItemEntry(Object object) {
        if (object == null) {
            return null;
        }
        TreeItem[] treeItemArray = this._tree.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n].getData().equals(((TreeItem)object).getData())) {
                return treeItemArray[n];
            }
            ++n;
        }
        return null;
    }

    protected TreeItem getItem(Object object) {
        if (object == null) {
            return null;
        }
        TreeItem[] treeItemArray = this._tree.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n].getData().toString().equals(object.toString())) {
                return treeItemArray[n];
            }
            ++n;
        }
        return null;
    }

    protected TreeItem getItem(TreeItem treeItem, Object object) {
        if (treeItem == null) {
            return this.getItem(object);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n].getData().toString().equals(object.toString())) {
                return treeItemArray[n];
            }
            ++n;
        }
        return null;
    }

    public TreeItem[] getSelectedItems() {
        return this._tree.getSelection();
    }

    public Tree getTree() {
        return this._tree;
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public void addProcessToTree(Process process, boolean bl, boolean bl2) {
        Enumeration enumeration = process.listAgents();
        boolean bl3 = UIPlugin.getDefault().getPreferenceStore().getBoolean("log_option");
        boolean bl4 = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");
        if (bl || enumeration.hasMoreElements()) {
            TreeItem treeItem = null;
            while (enumeration.hasMoreElements()) {
                Agent agent = (Agent)enumeration.nextElement();
                if (!agent.isActive() || !bl2 && agent.isAttached()) continue;
                if (bl3 && agent.getType().equals("Logging")) {
                    if (treeItem == null) {
                        treeItem = this.createItem(null, process, false);
                    }
                    this.createItem(treeItem, agent, false);
                    continue;
                }
                if (bl4 && agent.getType().equals("Profiler")) {
                    if (treeItem == null) {
                        treeItem = this.createItem(null, process, false);
                    }
                    this.createItem(treeItem, agent, false);
                    continue;
                }
                ArrayList arrayList = this.getAgentTypeList();
                int n = 0;
                while (n < arrayList.size()) {
                    if (!agent.getType().equals("Logging") && agent.getType().equals((String)arrayList.get(n))) {
                        if (treeItem == null) {
                            treeItem = this.createItem(null, process, false);
                        }
                        this.createItem(treeItem, agent, false);
                    }
                    ++n;
                }
            }
        }
    }

    public void initializeTree(Enumeration enumeration, boolean bl, boolean bl2) {
        this.removeAll();
        if (enumeration == null) {
            return;
        }
        this._tree.setRedraw(false);
        while (enumeration.hasMoreElements()) {
            this.addProcessToTree((Process)enumeration.nextElement(), bl, bl2);
        }
        this._tree.setRedraw(true);
    }

    public void refreshTree(Vector vector) {
        if (vector.size() < 2) {
            return;
        }
        this._tree.setRedraw(false);
        int n = 0;
        while (n < vector.size()) {
            TreeItem treeItem = (TreeItem)vector.elementAt(n);
            TreeItem treeItem2 = new TreeItem(this._tree, 0);
            this.setItemData(treeItem2, treeItem.getData());
            TreeItem[] treeItemArray = treeItem.getItems();
            int n2 = 0;
            while (n2 < treeItemArray.length) {
                TreeItem treeItem3 = new TreeItem(treeItem2, 0);
                this.setItemData(treeItem3, treeItemArray[n2].getData());
                ++n2;
            }
            treeItem.dispose();
            ++n;
        }
        this._tree.setRedraw(true);
    }

    public void remove(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        treeItem.dispose();
        if (treeItem2 != null && treeItem2.getItemCount() == 0) {
            treeItem2.dispose();
        }
    }

    public void removeAll() {
        this._tree.removeAll();
    }

    protected void setItemData(TreeItem treeItem, Object object) {
        treeItem.setData(object);
        if (treeItem.getParentItem() == null) {
            String string = ((Process)object).getName();
            if (string == null) {
                string = ((Process)object).getExecutable();
            }
            try {
                string = string + "[PID:" + ((Process)object).getProcessId() + "]";
            }
            catch (InactiveProcessException inactiveProcessException) {
                // empty catch block
            }
            treeItem.setText(string);
            treeItem.setImage(PDPluginImages.getImage("process_obj.gif"));
        } else {
            treeItem.setText(((Agent)object).getName());
            treeItem.setImage(PDPluginImages.getImage("agent_detach_obj.gif"));
        }
    }

    public void setToolTipText(String string) {
        this._tree.setToolTipText(string);
    }

    public void sortSubItem(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            TreeItem treeItem = (TreeItem)vector.elementAt(n);
            TreeItem[] treeItemArray = treeItem.getItems();
            if (treeItemArray == null || treeItemArray.length == 0) {
                return;
            }
            Vector<TreeItem> vector2 = new Vector<TreeItem>(treeItemArray.length);
            int n2 = 0;
            while (n2 < treeItemArray.length) {
                vector2.addElement(treeItemArray[n2]);
                ++n2;
            }
            this.refreshAgents(vector2, treeItem);
            ++n;
        }
    }

    public void refreshAgents(Vector vector, TreeItem treeItem) {
        if (vector.size() < 2) {
            return;
        }
        this._tree.setRedraw(false);
        int n = 0;
        while (n < vector.size()) {
            TreeItem treeItem2 = (TreeItem)vector.elementAt(n);
            TreeItem treeItem3 = new TreeItem(treeItem, 0);
            this.setItemData(treeItem3, treeItem2.getData());
            treeItem2.dispose();
            ++n;
        }
        this._tree.setRedraw(true);
    }

    protected ArrayList getAgentTypeList() {
        if (this.fAgentTypeList == null) {
            this.fAgentTypeList = new ArrayList();
            this.fAgentTypeList.add("Logging");
        }
        return this.fAgentTypeList;
    }
}

