/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class HyperlinkText
extends StyledText {
    private ArrayList detailsHyperlinkRanges = new ArrayList();
    private ArrayList analyzeHyperlinkRanges = new ArrayList();
    private ArrayList actionRanges = new ArrayList();
    private IPropertyChangeListener colorListener;
    private String linkStart1 = "http://";
    private String linkStart2 = "https://";
    int[][] detailsRanges;
    private Cursor handCursor;
    private Cursor busyCursor;
    private boolean mouseDown = false;
    private boolean dragEvent = false;

    public HyperlinkText(Composite composite, int n) {
        super(composite, n);
        final Display display = composite.getDisplay();
        this.handCursor = new Cursor((Device)display, 21);
        this.busyCursor = new Cursor((Device)display, 1);
        this.colorListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("HYPERLINK_COLOR")) {
                    Color color = JFaceColors.getHyperlinkText((Display)display);
                    Iterator iterator = HyperlinkText.this.detailsHyperlinkRanges.iterator();
                    while (iterator.hasNext()) {
                        StyleRange styleRange = (StyleRange)iterator.next();
                        styleRange.foreground = color;
                    }
                }
            }
        };
        JFacePreferences.getPreferenceStore().addPropertyChangeListener(this.colorListener);
        Color color = JFaceColors.getBannerBackground((Display)display);
        Color color2 = JFaceColors.getBannerForeground((Display)display);
        JFaceColors.setColors((Control)this, (Color)color2, (Color)color);
        this.addListeners();
    }

    protected void addListeners() {
        if (!SWT.getPlatform().equals("win32")) {
            return;
        }
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button != 1) {
                    return;
                }
                HyperlinkText.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent mouseEvent) {
                HyperlinkText.this.mouseDown = false;
                StyledText styledText = (StyledText)mouseEvent.widget;
                int n = styledText.getCaretOffset();
                if (HyperlinkText.this.dragEvent) {
                    HyperlinkText.this.dragEvent = false;
                    if (HyperlinkText.this.isLinkAt(n)) {
                        styledText.setCursor(HyperlinkText.this.handCursor);
                    }
                } else if (HyperlinkText.this.isLinkAt(n)) {
                    styledText.setCursor(HyperlinkText.this.busyCursor);
                    if (mouseEvent.button == 1) {
                        HyperlinkText.this.triggerLinkAt(n);
                        StyleRange styleRange = HyperlinkText.this.getCurrentLink();
                        styledText.setSelectionRange(styleRange.start, styleRange.length);
                        styledText.setCursor(null);
                    }
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (HyperlinkText.this.mouseDown) {
                    if (!HyperlinkText.this.dragEvent) {
                        StyledText styledText = (StyledText)mouseEvent.widget;
                        styledText.setCursor(null);
                    }
                    HyperlinkText.this.dragEvent = true;
                    return;
                }
                StyledText styledText = (StyledText)mouseEvent.widget;
                int n = -1;
                try {
                    n = styledText.getOffsetAtLocation(new Point(mouseEvent.x, mouseEvent.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (n == -1) {
                    styledText.setCursor(null);
                } else if (HyperlinkText.this.isLinkAt(n)) {
                    styledText.setCursor(HyperlinkText.this.handCursor);
                } else {
                    styledText.setCursor(null);
                }
            }
        });
    }

    private boolean isLinkAt(int n) {
        if (this.detailsRanges == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.detailsRanges.length) {
            if (n >= this.detailsRanges[n2][0] && n < this.detailsRanges[n2][0] + this.detailsRanges[n2][1]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void openBrowser(String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        if (SWT.getPlatform().equals("win32")) {
            Program.launch((String)string);
        }
    }

    protected StyleRange getCurrentLink() {
        StyleRange[] styleRangeArray = this.getStyleRanges();
        int n = this.getSelection().y;
        int n2 = this.getSelection().x;
        int n3 = 0;
        while (n3 < styleRangeArray.length) {
            if (n2 >= styleRangeArray[n3].start && n <= styleRangeArray[n3].start + styleRangeArray[n3].length) {
                return styleRangeArray[n3];
            }
            ++n3;
        }
        return null;
    }

    protected void triggerLinkAt(int n) {
        if (this.detailsRanges == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.detailsRanges.length) {
            if (n >= this.detailsRanges[n2][0] && n < this.detailsRanges[n2][0] + this.detailsRanges[n2][1]) {
                this.openBrowser(this.getText().substring(this.detailsRanges[n2][0], this.detailsRanges[n2][0] + this.detailsRanges[n2][1]));
                return;
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        if (this.colorListener != null) {
            JFacePreferences.getPreferenceStore().removePropertyChangeListener(this.colorListener);
        }
        this.colorListener = null;
    }

    private void setLinkRanges(String string) {
        this.actionRanges.clear();
        this.detailsHyperlinkRanges.clear();
        if (string == null || string.length() == 0) {
            return;
        }
        this.findLinks(string, this.linkStart1);
        this.findLinks(string, this.linkStart2);
        Color color = JFaceColors.getHyperlinkText((Display)this.getShell().getDisplay());
        this.detailsRanges = (int[][])this.actionRanges.toArray((T[])new int[this.actionRanges.size()][2]);
        int n = 0;
        while (n < this.detailsRanges.length) {
            StyleRange styleRange = new StyleRange(this.detailsRanges[n][0], this.detailsRanges[n][1], color, null, 0);
            this.setStyleRange(styleRange);
            this.detailsHyperlinkRanges.add(styleRange);
            ++n;
        }
    }

    protected void findLinks(String string, String string2) {
        int n = string.indexOf(string2);
        int n2 = 0;
        while (n != -1) {
            String string3 = string.substring(n2 + n);
            int n3 = string3.indexOf(" ");
            if (n3 == -1) {
                n3 = string3.indexOf("\n");
            }
            if (n3 == -1) {
                this.actionRanges.add(new int[]{n + n2, string3.length() - n});
                string = "";
            } else {
                this.actionRanges.add(new int[]{n + n2, n3});
                string3 = string3.substring(n3 + 1);
                n2 += n3 + 1;
            }
            n2 += n;
            n = string3.indexOf(string2);
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.setLinkRanges(string);
    }
}

