/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingListContentProvider;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingTypeElement;
import org.eclipse.jface.viewers.IBasicPropertyConstants;
import org.eclipse.jface.viewers.TableViewer;

public class ProfilingList
implements IBasicPropertyConstants {
    ArrayList types = new ArrayList();
    TableViewer fViewer;
    protected List listeners;

    public ProfilingList(TableViewer tableViewer) {
        this.fViewer = tableViewer;
    }

    public void add(ProfilingTypeElement profilingTypeElement) {
        this.add(profilingTypeElement, -1);
    }

    public void add(ProfilingTypeElement profilingTypeElement, int n) {
        if (n < 0) {
            this.types.add(profilingTypeElement);
        } else {
            this.types.add(n, profilingTypeElement);
        }
    }

    public void addElementChangedListener(ProfilingListContentProvider profilingListContentProvider) {
        if (profilingListContentProvider == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(profilingListContentProvider)) {
            this.listeners.add(profilingListContentProvider);
        }
    }

    public Object[] elements() {
        return this.types.toArray();
    }

    public void fireElementChanged(ProfilingTypeElement profilingTypeElement, String string) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ProfilingListContentProvider profilingListContentProvider = (ProfilingListContentProvider)iterator.next();
                profilingListContentProvider.elementChanged(profilingTypeElement, string);
            }
        }
    }

    public Object getElementAt(int n) {
        return this.types.get(n);
    }

    public ArrayList getFilters() {
        return (ArrayList)this.types.clone();
    }

    public int getSize() {
        return this.types.size();
    }

    public void removeAll() {
        this.types.clear();
    }

    public void removeElements(int[] nArray) {
        if (nArray == null) {
            return;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != -1) {
                Object e = this.types.get(nArray[n]);
                vector.add(e);
            }
            ++n;
        }
        this.types.removeAll(vector);
    }

    public Object removeElementAt(int n) {
        Object e = this.types.get(n);
        if (e == null) {
            return null;
        }
        this.types.remove(e);
        return e;
    }

    public void removeElementChangedListener(ProfilingListContentProvider profilingListContentProvider) {
        if (this.listeners != null) {
            this.listeners.remove(profilingListContentProvider);
        }
    }

    public Object[] uiElements() {
        return this.types.toArray();
    }
}

