/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.ui.HyadesUIPlugin;

public class ProfilingSetsManagerCopy
extends ProfilingSetsManager {
    public ProfilingSetsManagerCopy() {
        this.initialize();
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        String string = this.getDefaultSet().getId();
        String string2 = this.getDefaultFilterSet().getName();
        try {
            Map map;
            String string3 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, string);
            String string4 = iLaunchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, string2);
            IProfilingSet iProfilingSet = (IProfilingSet)this.getProfilingSets().get(string3);
            FilterSetElement filterSetElement = (FilterSetElement)this.getFilterSets().get(string4);
            if (iProfilingSet == null && (map = this.getProfilingSets()).size() > 0) {
                iProfilingSet = (IProfilingSet)map.values().iterator().next();
            }
            if (filterSetElement == null && (map = this.getFilterSets()).size() > 0) {
                filterSetElement = (FilterSetElement)map.values().iterator().next();
            }
            this.setDefaultSet(iProfilingSet);
            this.setDefaultFilterSet(filterSetElement);
        }
        catch (CoreException coreException) {
            HyadesUIPlugin.logError((Throwable)coreException);
        }
    }

    public static ProfilingSetsManager instance() {
        return null;
    }

    public void applyChanges() {
        ProfilingSetsManager profilingSetsManager = ProfilingSetsManager.instance();
        profilingSetsManager.getProfilingSets().clear();
        profilingSetsManager.getProfilingSets().putAll(this.getProfilingSets());
        profilingSetsManager.getProfilingTypes().clear();
        profilingSetsManager.getProfilingTypes().putAll(this.getProfilingTypes());
        profilingSetsManager.getProfilingTypesGroups().clear();
        profilingSetsManager.getProfilingTypesGroups().putAll(this.getProfilingTypesGroups());
        profilingSetsManager.getFilterSets().clear();
        profilingSetsManager.getFilterSets().putAll(this.getFilterSets());
        profilingSetsManager.setDefaultSet(this.getDefaultSet());
        profilingSetsManager.setDefaultFilterSet(this.getDefaultFilterSet());
        this.writeSetsToPreferences();
    }

    protected void initializeProfilingTypesGroups() {
        this.profilingTypesGroups = new HashMap();
        Map map = ProfilingSetsManager.instance().getProfilingTypesGroups();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            IProfilingSetTypeGroup iProfilingSetTypeGroup = (IProfilingSetTypeGroup)map.get(string);
            this.profilingTypesGroups.put(string, new ProfilingSetTypeGroup(iProfilingSetTypeGroup.getId(), iProfilingSetTypeGroup.getName(), iProfilingSetTypeGroup.getDescription(), iProfilingSetTypeGroup.getIcon()));
        }
    }

    protected void initializeProfilingTypes() {
        this.profilingTypes = new HashMap();
        Map map = ProfilingSetsManager.instance().getProfilingTypes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            IProfilingSetType iProfilingSetType = (IProfilingSetType)map.get(string);
            this.profilingTypes.put(string, new ProfilingSetType(iProfilingSetType.getId(), iProfilingSetType.getName(), iProfilingSetType.getDescription(), iProfilingSetType.getImage(), iProfilingSetType.isUseFilters(), iProfilingSetType.getGroup(), iProfilingSetType.getProfilingType()));
        }
    }

    protected void initializeProfilingSets() {
        this.profilingSets = new HashMap();
        IProfilingSet iProfilingSet = ProfilingSetsManager.instance().getDefaultSet();
        Map map = ProfilingSetsManager.instance().getProfilingSets();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            IProfilingSet iProfilingSet2 = (IProfilingSet)map.get(string);
            ProfilingSet profilingSet = new ProfilingSet(iProfilingSet2.getId(), iProfilingSet2.getName(), iProfilingSet2.getDescription());
            profilingSet.getProfilingTypes().addAll(iProfilingSet2.getProfilingTypes());
            profilingSet.getAttributes().putAll(iProfilingSet2.getAttributes());
            this.profilingSets.put(string, profilingSet);
            if (iProfilingSet2 != iProfilingSet) continue;
            this.setDefaultSet(profilingSet);
        }
    }

    protected void initializeFilterSets() {
        this.filterSets = new HashMap();
        Map map = ProfilingSetsManager.instance().getFilterSets();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            FilterSetElement filterSetElement = (FilterSetElement)map.get(string);
            FilterSetElement filterSetElement2 = new FilterSetElement(filterSetElement.getName());
            ArrayList arrayList = filterSetElement.getChildren();
            ArrayList<FilterTableElement> arrayList2 = new ArrayList<FilterTableElement>();
            int n = 0;
            while (n < arrayList.size()) {
                FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
                arrayList2.add(new FilterTableElement(filterTableElement.getText(), filterTableElement.getMethod(), filterTableElement.getVisibility()));
                ++n;
            }
            filterSetElement2.setChildren(arrayList2);
            this.filterSets.put(string, filterSetElement2);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IProfilingSet iProfilingSet = this.getDefaultSet();
        if (iProfilingSet != null) {
            Object object;
            Iterator iterator = iProfilingSet.getAttributes().values().iterator();
            while (iterator.hasNext()) {
                object = (ProfilingAttribute)iterator.next();
                iLaunchConfigurationWorkingCopy.setAttribute(((ProfilingAttribute)object).getName(), ((ProfilingAttribute)object).getValue());
            }
            object = this.getDefaultFilterSet();
            String string = null;
            if (object != null) {
                string = ((FilterSetElement)object).getName();
            }
            iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, iProfilingSet.getId());
            iLaunchConfigurationWorkingCopy.setAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, string);
        }
    }

    public ProfilingSetsManagerCopy createCopy() {
        ProfilingSetsManagerCopy profilingSetsManagerCopy = new ProfilingSetsManagerCopy();
        profilingSetsManagerCopy.resetFrom(this);
        return profilingSetsManagerCopy;
    }

    public void resetFrom(ProfilingSetsManagerCopy profilingSetsManagerCopy) {
        this.getProfilingSets().clear();
        this.getProfilingSets().putAll(profilingSetsManagerCopy.getProfilingSets());
        this.getProfilingTypes().clear();
        this.getProfilingTypes().putAll(profilingSetsManagerCopy.getProfilingTypes());
        this.getProfilingTypesGroups().clear();
        this.getProfilingTypesGroups().putAll(profilingSetsManagerCopy.getProfilingTypesGroups());
        this.getFilterSets().clear();
        this.getFilterSets().putAll(profilingSetsManagerCopy.getFilterSets());
        this.setDefaultSet(profilingSetsManagerCopy.getDefaultSet());
        this.setDefaultFilterSet(profilingSetsManagerCopy.getDefaultFilterSet());
    }
}

