/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.codegen;

import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.INamedElement;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.internal.codegen.ImportManager;
import org.eclipse.hyades.test.http.internal.codegen.GenTestSuite;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.http.runner.HttpHeader;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.ui.internal.util.StringUtil;

class GenTestSuite {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = "\t\t" + this.NL;
    protected final String TEXT_2 = this.NL + "package ";
    protected final String TEXT_3 = ";" + this.NL;
    protected final String TEXT_4 = this.NL + this.NL + "/**" + this.NL + " * Generated code for the test suite <b>";
    protected final String TEXT_5 = "</b> located at" + this.NL + " * <i>";
    protected final String TEXT_6 = "</i>";
    protected final String TEXT_7 = ".";
    protected final String TEXT_8 = this.NL + " *" + this.NL + " * ";
    protected final String TEXT_9 = this.NL + " */" + this.NL + "public class ";
    protected final String TEXT_10 = this.NL + "extends ";
    protected final String TEXT_11 = this.NL + "{" + this.NL + "\t/**" + this.NL + "\t * Constructor for ";
    protected final String TEXT_12 = "." + this.NL + "\t * @param name" + this.NL + "\t */" + this.NL + "\tpublic ";
    protected final String TEXT_13 = "(String name)" + this.NL + "\t{" + this.NL + "\t\tsuper(name);" + this.NL + "\t}" + this.NL + "" + this.NL + "\t/**" + this.NL + "\t * Returns the JUnit test suite that implements the <b>";
    protected final String TEXT_14 = "</b>" + this.NL + "\t * definition." + this.NL + "\t */" + this.NL + "\tpublic static Test suite()" + this.NL + "\t{";
    protected final String TEXT_15 = "\t\t";
    protected final String TEXT_16 = " ";
    protected final String TEXT_17 = " = new ";
    protected final String TEXT_18 = "(\"";
    protected final String TEXT_19 = "\");" + this.NL + "\t\t";
    protected final String TEXT_20 = ".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"";
    protected final String TEXT_21 = "\");" + this.NL + "\t\t";
    protected final String TEXT_22 = this.NL + "        ";
    protected final String TEXT_23 = this.NL + this.NL + "\t\treturn ";
    protected final String TEXT_24 = ";" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\t/**" + this.NL + "\t * @see junit.framework.TestCase#setUp()" + this.NL + "\t */" + this.NL + "\tprotected void setUp()" + this.NL + "\tthrows ";
    protected final String TEXT_25 = this.NL + "\t{" + this.NL + "\t}" + this.NL + "" + this.NL + "\t/**" + this.NL + "\t * @see junit.framework.TestCase#tearDown()" + this.NL + "\t */" + this.NL + "\tprotected void tearDown()" + this.NL + "\tthrows ";
    protected final String TEXT_26 = this.NL + "\t{" + this.NL + "\t}\t";
    protected final String TEXT_27 = this.NL + this.NL + "/**" + this.NL + " * ";
    protected final String TEXT_28 = this.NL + " *" + this.NL + " * ";
    protected final String TEXT_29 = this.NL + " * ";
    protected final String TEXT_30 = this.NL + " * @throws ";
    protected final String TEXT_31 = this.NL + " */" + this.NL + "\tpublic void ";
    protected final String TEXT_32 = "()" + this.NL + "\tthrows ";
    protected final String TEXT_33 = this.NL + "\t{" + this.NL + "\t\t";
    protected final String TEXT_34 = this.NL + "\t}";
    protected final String TEXT_35 = this.NL;
    protected final String TEXT_36 = "\t/*********************" + this.NL + "\t *  Member variables *" + this.NL + "\t *********************/" + this.NL + "\tstatic protected ";
    protected final String TEXT_37 = "[] m_httpCookieCache;" + this.NL + "\tstatic protected ";
    protected final String TEXT_38 = "[] m_httpExecutor;" + this.NL + "\tprotected ";
    protected final String TEXT_39 = " rand = new Random();" + this.NL + "\t" + this.NL + "\t/*********************" + this.NL + "\t *    Extra Methods  *" + this.NL + "\t *********************/" + this.NL + "\tpublic void populateCookieCache(";
    protected final String TEXT_40 = " cookies)" + this.NL + "\t{" + this.NL + "\t\t//By default, the cookie cache is created empty.  To add new cookies, use the following" + this.NL + "\t\t//cookies.AddCookie(name, value, domain, path, expires, bSecure);" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\tprotected void executeRequest(";
    protected final String TEXT_41 = " request)" + this.NL + "\tthrows ";
    protected final String TEXT_42 = this.NL + "\t{" + this.NL + "\t\tif (m_httpExecutor == null || m_httpCookieCache == null)" + this.NL + "\t\t\tinitializeTest();" + this.NL + "" + this.NL + "\t\tint nUser = ";
    protected final String TEXT_43 = ".getCurrentUser(this);" + this.NL + "\t\tm_httpCookieCache[nUser].DynamicGetCookie(request);" + this.NL + "\t\t";
    protected final String TEXT_44 = " response = m_httpExecutor[nUser].execute(request);" + this.NL + "\t\t" + this.NL + "\t\tString text = \"rc=\" + Integer.toString(response.getCode());" + this.NL + "\t\tif(response.getDetail() != null)" + this.NL + "\t\t\ttext = \"\\n\\n\" + response.getDetail();" + this.NL + "" + this.NL + "\t\t//If (response.getCode() < 0) then there was an error when executing the request" + this.NL + "\t\tif(response.getCode() < 0)" + this.NL + "\t\t\tthrow new ";
    protected final String TEXT_45 = "(text);" + this.NL + "" + this.NL + "       try {" + this.NL + "\t         m_httpCookieCache[nUser].DynamicSetCookie(request, response);" + this.NL + "\t       }" + this.NL + "\t   catch(Exception e)" + this.NL + "\t       {" + this.NL + "\t       }" + this.NL + "\t\t" + this.NL + "\t\t//If (response.getCode() < 400) then the request has failed." + this.NL + "\t\tassertTrue(text, response.getCode() < 400 && response.getCode() > 0);" + this.NL + "\t}" + this.NL + "\t" + this.NL + "\tsynchronized protected void initializeTest() " + this.NL + "\t{" + this.NL + "\t\tint nTotal = ";
    protected final String TEXT_46 = ".getTotalUsers(this);" + this.NL + "\t\tif (m_httpCookieCache == null)" + this.NL + "\t\t{" + this.NL + "\t\t\tm_httpCookieCache = new ";
    protected final String TEXT_47 = "[nTotal];" + this.NL + "\t\t\tfor (int i = 0; i < nTotal; i++)" + this.NL + "\t\t\t{ " + this.NL + "\t\t\t\tm_httpCookieCache[i] = new ";
    protected final String TEXT_48 = "();" + this.NL + "\t\t\t\tpopulateCookieCache(m_httpCookieCache[i]);" + this.NL + "\t\t\t}" + this.NL + "\t\t\t " + this.NL + "\t\t}" + this.NL + "\t\tif (m_httpExecutor == null)" + this.NL + "\t\t{\t" + this.NL + "\t\t\tm_httpExecutor = new ";
    protected final String TEXT_49 = "[nTotal];" + this.NL + "\t\t\tfor (int i = 0; i < nTotal; i++)" + this.NL + "\t\t\t{" + this.NL + "\t\t\t\tm_httpExecutor[i] = new ";
    protected final String TEXT_50 = "();" + this.NL + "\t\t\t}" + this.NL + "\t\t}" + this.NL + "\t}\t" + this.NL + "\t" + this.NL + "\tprotected long calcThinkTime(long think, int var) " + this.NL + "\t{" + this.NL + "\t\tif (var > 0 && var < 99) {" + this.NL + "\t\t\tlong delta = think * var / 100;" + this.NL + "\t\t\tthink += (rand.nextInt((int) delta * 2) - delta);" + this.NL + "\t\t}" + this.NL + "\t\treturn think;" + this.NL + "\t}" + this.NL + "\t}";

    GenTestSuite() {
    }

    public String generate(ITestSuite iTestSuite, Helper helper) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        String string = helper.getPackageName((Object)iTestSuite);
        String string2 = helper.retrieveClassName((INamedElement)iTestSuite);
        String string3 = iTestSuite.getDescription();
        string3 = string3 != null ? StringUtil.replace((String)string3.trim(), (String)this.NL, (String)(this.NL + " * ")) : "";
        helper.setImportManager(new ImportManager(string));
        helper.getImportedName(string + "." + string2);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(string);
        stringBuffer.append(this.TEXT_3);
        helper.addImport("junit.framework.Test");
        helper.addImport("org.eclipse.hyades.test.common.junit.DefaultTestArbiter");
        helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestCase");
        helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
        helper.markImportLocation(stringBuffer);
        String string4 = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
        String string5 = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestCase");
        String string6 = helper.getImportedName("java.lang.Exception");
        String string7 = helper.getFilePath((Object)iTestSuite);
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(helper.getLabel((Object)iTestSuite));
        if (string7 != null) {
            stringBuffer.append(this.TEXT_5);
            stringBuffer.append(string7);
            stringBuffer.append("</i>");
        }
        stringBuffer.append(".");
        if (string3.length() > 0) {
            stringBuffer.append(this.TEXT_8);
            stringBuffer.append(string3);
        }
        stringBuffer.append(this.TEXT_9);
        stringBuffer.append(string2);
        stringBuffer.append(this.TEXT_10);
        stringBuffer.append(string5);
        stringBuffer.append(this.TEXT_11);
        stringBuffer.append(string2);
        stringBuffer.append(this.TEXT_12);
        stringBuffer.append(string2);
        stringBuffer.append(this.TEXT_13);
        stringBuffer.append(helper.getLabel((Object)iTestSuite));
        stringBuffer.append(this.TEXT_14);
        String string8 = helper.retrieveIdentifierName((INamedElement)iTestSuite, (Object)"SUITE");
        class InvocationGenerator {
            private String hyadesTestSuiteClassName;
            private final /* synthetic */ Helper val$helper;
            private final /* synthetic */ GenTestSuite this$0;

            public InvocationGenerator(GenTestSuite genTestSuite, String string, Helper helper) {
                this.this$0 = genTestSuite;
                this.val$helper = helper;
                this.hyadesTestSuiteClassName = string;
            }

            public StringBuffer generate(String string, List list) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                Iterator<E> iterator = list.iterator();
                while (iterator.hasNext()) {
                    IAction iAction = (IAction)iterator.next();
                    if (iAction instanceof ITestInvocation) {
                        stringBuffer2 = this.generate(string, (ITestInvocation)iAction);
                    } else {
                        if (!(iAction instanceof ILoop)) continue;
                        stringBuffer2 = this.generate(string, (ILoop)iAction);
                    }
                    if (stringBuffer2 == null) {
                        stringBuffer.append(this.this$0.NL).append("//ERROR: No definition found for test element: ").append(iAction.getName()).append(this.this$0.NL).append(this.this$0.NL);
                        continue;
                    }
                    if (stringBuffer2.length() == 0) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(this.this$0.NL).append(this.this$0.NL);
                    }
                    stringBuffer.append(stringBuffer2.toString());
                }
                return stringBuffer;
            }

            private StringBuffer generate(String string, ITestInvocation iTestInvocation) {
                StringBuffer stringBuffer = new StringBuffer(string).append(".addTest(");
                ITest iTest = iTestInvocation.getInvokedTest();
                if (iTest == null) {
                    return null;
                }
                if (iTest instanceof ITestSuite) {
                    stringBuffer.append("((").append(this.hyadesTestSuiteClassName).append(")").append(this.val$helper.getImportedName(iTest.getImplementor().getResource())).append(".suite())");
                } else {
                    ITestCase iTestCase = (ITestCase)iTest;
                    String string2 = iTestCase.getImplementor().getResource();
                    if (string2 == null) {
                        string2 = this.val$helper.retrieveIdentifierName((INamedElement)iTestCase, (Object)"METHOD");
                    }
                    stringBuffer.append("new ").append(this.val$helper.getImportedName(iTestCase.getOwner().getImplementor().getResource())).append("(\"").append(string2).append("\")");
                    stringBuffer.append(".setId(\"").append(iTest.getId()).append("\")");
                }
                stringBuffer.append(".setTestInvocationId(\"").append(iTestInvocation.getId()).append("\")");
                if (!iTestInvocation.isSynchronous()) {
                    stringBuffer.append(".setSynchronous(false)");
                }
                return stringBuffer.append(");");
            }

            private StringBuffer generate(String string, ILoop iLoop) {
                List list;
                String string2 = this.val$helper.retrieveIdentifierName((INamedElement)iLoop, (Object)"METHOD");
                String string3 = iLoop.getName();
                string3 = string3 == null ? "" : "\"" + string3 + "\"";
                StringBuffer stringBuffer = new StringBuffer(this.hyadesTestSuiteClassName).append(" ").append(string2);
                stringBuffer.append(" = new ").append(this.hyadesTestSuiteClassName).append("(").append(string3).append(");").append(this.this$0.NL);
                stringBuffer.append(string).append(".addTest(new ").append(this.val$helper.getImportedName("junit.extensions.RepeatedTest")).append("(").append(string2).append(", ").append(iLoop.getCondition().getConstraint()).append("));").append(this.this$0.NL);
                stringBuffer.append(string2).append(".setId(\"").append(iLoop.getId()).append("\")");
                if (!iLoop.isSynchronous()) {
                    stringBuffer.append(".setSynchronous(false)");
                }
                stringBuffer.append(";");
                IProperty iProperty = iLoop.getActionProperties().getPropertyByName("HTTPPAGE");
                if (iProperty != null && (list = iLoop.getBlock().getActions()).size() >= 1) {
                    Object object;
                    ITest iTest;
                    if (list.size() == 1 && list.get(0) instanceof ITestInvocation && (iTest = ((ITestInvocation)list.get(0)).getInvokedTest()) != null) {
                        object = HyadesFactory.INSTANCE.createVariable();
                        object.setInitialValue("PAGE_ONLY");
                        object.setName("pageOrder");
                        iTest.getVariables().add(object);
                    }
                    int n = 0;
                    while (n < list.size()) {
                        ITest iTest2;
                        object = list.get(n);
                        if (object instanceof ITestInvocation && (iTest2 = ((ITestInvocation)object).getInvokedTest()) != null) {
                            IVariable iVariable = HyadesFactory.INSTANCE.createVariable();
                            if (n == 0) {
                                iVariable.setInitialValue("PAGE_START");
                            } else if (n == list.size() - 1) {
                                iVariable.setInitialValue("PAGE_END");
                            } else {
                                iVariable.setInitialValue("PAGE_MID");
                            }
                            iVariable.setName("pageOrder");
                            iTest2.getVariables().add(iVariable);
                        }
                        ++n;
                    }
                }
                return stringBuffer.append(this.this$0.NL).append(this.this$0.NL).append(this.generate(string2, iLoop.getBlock().getActions()).toString());
            }
        }
        String string9 = new InvocationGenerator(this, string4, helper).generate(string8, iTestSuite.getImplementor().getBlock().getActions()).toString();
        stringBuffer.append("\t\t");
        stringBuffer.append(string4);
        stringBuffer.append(" ");
        stringBuffer.append(string8);
        stringBuffer.append(" = new ");
        stringBuffer.append(string4);
        stringBuffer.append("(\"");
        stringBuffer.append(helper.getLabel((Object)iTestSuite));
        stringBuffer.append(this.TEXT_19);
        stringBuffer.append(string8);
        stringBuffer.append(".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"");
        stringBuffer.append(iTestSuite.getId());
        stringBuffer.append(this.TEXT_21);
        stringBuffer.append(this.TEXT_22);
        stringBuffer.append(string9);
        stringBuffer.append(this.TEXT_23);
        stringBuffer.append(string8);
        stringBuffer.append(this.TEXT_24);
        stringBuffer.append(string6);
        stringBuffer.append(this.TEXT_25);
        stringBuffer.append(string6);
        stringBuffer.append(this.TEXT_26);
        class MethodBodyGenerator {
            int think_time;
            int variance;
            private final /* synthetic */ Helper val$helper;
            private final /* synthetic */ GenTestSuite this$0;

            MethodBodyGenerator(GenTestSuite genTestSuite, Helper helper) {
                this.this$0 = genTestSuite;
                this.val$helper = helper;
                this.think_time = Integer.parseInt(HttpPreferenceUtil.getInstance().getDefaultThinkTime());
                this.variance = this.think_time > 0 ? Integer.parseInt(HttpPreferenceUtil.getInstance().getDefaultVariance()) : 0;
            }

            public StringBuffer generate(ITestCase iTestCase) {
                StringBuffer stringBuffer = this.generateHttp(iTestCase);
                if (stringBuffer == null) {
                    stringBuffer = this.generateDefault();
                }
                return stringBuffer;
            }

            protected StringBuffer generateHttp(ITestCase iTestCase) {
                HttpHeader[] httpHeaderArray;
                RequestHelper requestHelper = new RequestHelper();
                requestHelper.setTestCase(iTestCase);
                HttpRequest httpRequest = requestHelper.createHttpRequest();
                if (httpRequest == null) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")).append(" request = new ").append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest")).append("();");
                String string = null;
                string = httpRequest.getMethod();
                if (string != null) {
                    stringBuffer.append(this.this$0.NL).append("request.setMethod(\"").append(this.adjustString(string)).append("\");");
                }
                if (this.think_time > 0) {
                    long l = httpRequest.getThinkTime();
                    if (l == -1L) {
                        l = this.think_time;
                    }
                    if (l > 0L) {
                        stringBuffer.append("\n").append("request.setThinkTime( calcThinkTime( ").append(l).append(",").append(this.variance).append(" ));");
                    }
                }
                if ((string = httpRequest.getVersion()) != null) {
                    stringBuffer.append(this.this$0.NL).append("request.setVersion(\"").append(this.adjustString(string)).append("\");");
                }
                if ((string = httpRequest.getHost()) != null) {
                    stringBuffer.append(this.this$0.NL).append("request.setHost(\"").append(this.adjustString(string)).append("\");");
                }
                if (httpRequest.getPort() > 0) {
                    stringBuffer.append(this.this$0.NL).append("request.setPort(").append(httpRequest.getPort()).append(");");
                }
                if ((string = httpRequest.getAbsolutePath()) != null) {
                    stringBuffer.append(this.this$0.NL).append("request.setAbsolutePath(\"").append(this.adjustString(string)).append("\");");
                }
                if ((string = httpRequest.getBody()) != null) {
                    stringBuffer.append(this.this$0.NL).append("request.setBody(\"").append(this.adjustString(string)).append("\");");
                }
                if (httpRequest.getPageNumber() >= 0) {
                    stringBuffer.append(this.this$0.NL).append("request.setPageNumber(").append(httpRequest.getPageNumber()).append(");");
                }
                String string2 = this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_UNDEFINED";
                HttpHeader[] httpHeaderArray2 = null;
                Iterator<E> iterator = iTestCase.getVariables().iterator();
                if (iterator.hasNext()) {
                    httpHeaderArray = (HttpHeader[])iterator.next();
                    if (httpHeaderArray.getName().equals("pageOrder")) {
                        // empty if block
                    }
                    httpHeaderArray2 = httpHeaderArray;
                }
                if (httpHeaderArray2 != null) {
                    if (httpHeaderArray2.getInitialValue().equals("PAGE_ONLY")) {
                        string2 = this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_ONLY";
                    } else if (httpHeaderArray2.getInitialValue().equals("PAGE_START")) {
                        string2 = this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_START";
                    } else if (httpHeaderArray2.getInitialValue().equals("PAGE_MID")) {
                        string2 = this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_MID";
                    } else if (httpHeaderArray2.getInitialValue().equals("PAGE_END")) {
                        string2 = this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest") + ".PAGE_END";
                    }
                }
                stringBuffer.append(this.this$0.NL).append("request.setPageOrder(").append(string2).append(");");
                stringBuffer.append(this.this$0.NL).append("request.setSecure(").append(httpRequest.getSecure()).append(");");
                httpHeaderArray = httpRequest.getHeaders();
                if (httpHeaderArray.length > 0) {
                    int n = 0;
                    int n2 = httpHeaderArray.length;
                    while (n < n2) {
                        string = httpHeaderArray[n].getName();
                        if (string != null) {
                            stringBuffer.append(this.this$0.NL).append(this.this$0.NL);
                            if (n == 0) {
                                stringBuffer.append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpHeader")).append(" header;").append(this.this$0.NL);
                            }
                            stringBuffer.append("header = new ").append(this.val$helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpHeader")).append("();");
                            stringBuffer.append(this.this$0.NL).append("header.setName(\"").append(this.adjustString(string)).append("\");");
                            string = httpHeaderArray[n].getValue();
                            if (string != null) {
                                stringBuffer.append(this.this$0.NL).append("header.setValue(\"").append(this.adjustString(string)).append("\");");
                            }
                            stringBuffer.append(this.this$0.NL).append("request.addHeader(header);");
                        }
                        ++n;
                    }
                }
                stringBuffer.append(this.this$0.NL);
                stringBuffer.append(this.this$0.NL).append("executeRequest(request);");
                return stringBuffer;
            }

            protected StringBuffer generateDefault() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("// Enter your code here");
                return stringBuffer;
            }

            protected String adjustString(String string) {
                string = StringUtil.replace((String)string, (String)"\"", (String)"\\\"");
                return string;
            }
        }
        MethodBodyGenerator methodBodyGenerator = new MethodBodyGenerator(this, helper);
        Iterator iterator = iTestSuite.getITestCases().iterator();
        while (iterator.hasNext()) {
            ITestCase iTestCase = (ITestCase)iterator.next();
            string9 = methodBodyGenerator.generate(iTestCase).toString();
            String string10 = iTestCase.getImplementor().getResource();
            if (string10 == null) {
                string10 = helper.retrieveIdentifierName((INamedElement)iTestCase, (Object)"METHOD");
            }
            if (string10 == null) continue;
            string3 = iTestCase.getDescription();
            string3 = StringUtil.replace((String)string3, (String)this.NL, (String)(this.NL + " * "));
            stringBuffer.append(this.TEXT_27);
            stringBuffer.append(helper.getLabel((Object)iTestCase));
            if (string3 != null) {
                stringBuffer.append(this.TEXT_28);
                stringBuffer.append(string3);
                stringBuffer.append(this.TEXT_29);
            }
            stringBuffer.append(this.TEXT_30);
            stringBuffer.append(string6);
            stringBuffer.append(this.TEXT_31);
            stringBuffer.append(string10);
            stringBuffer.append(this.TEXT_32);
            stringBuffer.append(string6);
            stringBuffer.append(this.TEXT_33);
            stringBuffer.append(string9);
            stringBuffer.append(this.TEXT_34);
        }
        stringBuffer.append(this.TEXT_35);
        stringBuffer.append(this.TEXT_36);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_37);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
        stringBuffer.append(this.TEXT_38);
        stringBuffer.append(helper.getImportedName("java.util.Random"));
        stringBuffer.append(this.TEXT_39);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_40);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpRequest"));
        stringBuffer.append(this.TEXT_41);
        stringBuffer.append(string6);
        stringBuffer.append(this.TEXT_42);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.internal.util.HttpTestUtil"));
        stringBuffer.append(this.TEXT_43);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpResponse"));
        stringBuffer.append(this.TEXT_44);
        stringBuffer.append(string6);
        stringBuffer.append(this.TEXT_45);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.internal.util.HttpTestUtil"));
        stringBuffer.append(this.TEXT_46);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_47);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpCookieCache"));
        stringBuffer.append(this.TEXT_48);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
        stringBuffer.append(this.TEXT_49);
        stringBuffer.append(helper.getImportedName("org.eclipse.hyades.test.http.runner.HttpExecutor"));
        stringBuffer.append(this.TEXT_50);
        helper.emitSortedImports();
        return stringBuffer.toString();
    }
}

