/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports.responsetime;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.http.internal.reports.HttpAbstractReport;
import org.eclipse.hyades.test.http.internal.reports.responsetime.ResponseTimeData;

public class ResponseTimeReport
extends HttpAbstractReport {
    public ResponseTimeReport(TPFExecutionResult tPFExecutionResult) {
        super(tPFExecutionResult);
    }

    protected void finishReport() {
        if (HttpAbstractReport.list.size() > 1) {
            HttpAbstractReport.list.add(new ResponseTimeData.OverallResponseTime());
        }
    }

    protected void setupReport() {
        ResponseTimeData.resetCumulativeValues();
    }

    protected void processMessageEvent(TPFMessageEvent tPFMessageEvent) {
        String string = tPFMessageEvent.getText();
        int n = string.indexOf(HttpAbstractReport.responseTimeMarker);
        if (n != -1) {
            String string2 = string.substring(string.indexOf(HttpAbstractReport.pageNameMarker) + HttpAbstractReport.pageNameMarker.length(), n).trim();
            String string3 = string.substring(n + HttpAbstractReport.responseTimeMarker.length(), string.length());
            string3 = string3.substring(0, string3.indexOf("\r\n")).trim();
            System.out.println(string2 + ":" + string3);
            ResponseTimeData responseTimeData = (ResponseTimeData)this.findPage(string2);
            if (responseTimeData == null) {
                responseTimeData = new ResponseTimeData(string2);
                HttpAbstractReport.list.add(responseTimeData);
            }
            responseTimeData.addSample(new Long(string3));
        }
    }

    protected void processTypedEvent(TPFTypedEvent tPFTypedEvent) {
    }
}

