/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.launch.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.launch.HttpTestLaunchConfigurationFacade;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LoadTestUserTab
extends AbstractLaunchConfigurationTab {
    private String title = TestHttpPlugin.getString("LoadTestUserTab.Title");
    private Text _numUsers = null;
    private int _nUsers = 1;
    private Listener modifyListener = new Listener(){

        public void handleEvent(Event event) {
            block3: {
                if (event.widget != LoadTestUserTab.this._numUsers) break block3;
                String string = LoadTestUserTab.this._numUsers.getText();
                try {
                    int n = Integer.parseInt(string);
                    if (n > 1) {
                        LoadTestUserTab.this.setErrorMessage(null);
                        LoadTestUserTab.this._nUsers = n;
                        LoadTestUserTab.this.setDirty(true);
                        LoadTestUserTab.this.updateLaunchConfigurationDialog();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LoadTestUserTab.this._nUsers = 1;
                    LoadTestUserTab.this.setErrorMessage(TestHttpPlugin.getString("LoadTestUserTab.InvalidUsers"));
                }
            }
        }
    };

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 25;
        gridLayout.verticalSpacing = 25;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(TestHttpPlugin.getString("LoadTestUserTab.Users"));
        this._numUsers = new Text(composite2, 2048);
        this._numUsers.setText(Integer.toString(this._nUsers));
        this._numUsers.addListener(24, this.modifyListener);
        this._numUsers.setLayoutData((Object)new GridData(768));
        this.setMessage("Hello World");
        this.setControl((Control)composite2);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            TPFTest tPFTest = HttpTestLaunchConfigurationFacade.getTest(iLaunchConfiguration);
            int n = iLaunchConfiguration.getAttribute("org.eclipse.hyades.test.ui.launch.urlTest.users", 1);
            if (n > 0 && n != this._nUsers && this._numUsers != null) {
                this._numUsers.removeListener(24, this.modifyListener);
                this._nUsers = n;
                this._numUsers.setText(Integer.toString(this._nUsers));
                this._numUsers.addListener(24, this.modifyListener);
            }
        }
        catch (CoreException coreException) {
            TestHttpPlugin.logError(coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.hyades.test.ui.launch.urlTest.users", this._nUsers);
    }

    public String getName() {
        return this.title;
    }

    public int get_nUsers() {
        return this._nUsers;
    }

    public void set_nUsers(int n) {
        this._nUsers = n;
    }

    public Image getImage() {
        return TestHttpImages.INSTANCE.getImage("request.gif");
    }
}

