/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.hyades.logging.events.AssociatedEventImpl;
import org.eclipse.hyades.logging.events.AssociationEngineImpl;
import org.eclipse.hyades.logging.events.CbeFormatter;
import org.eclipse.hyades.logging.events.CommonBaseEventAnyElementImpl;
import org.eclipse.hyades.logging.events.ComponentIdentificationImpl;
import org.eclipse.hyades.logging.events.ContextDataElementImpl;
import org.eclipse.hyades.logging.events.ExtendedDataElementImpl;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.ICommonBaseEventAnyElement;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IMsgCatalogToken;
import org.eclipse.hyades.logging.events.IMsgDataElement;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.MsgDataElementImpl;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.events.SituationImpl;
import org.eclipse.hyades.logging.events.exceptions.InvalidXMLAnyElementException;
import org.eclipse.hyades.logging.events.exceptions.UnsupportedVersionException;

public class CommonBaseEventImpl
implements ICommonBaseEvent,
ISerializableAsXml,
Serializable,
Cloneable {
    static final long serialVersionUID = -4234730049423367771L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("extensionName", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("localInstanceId", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("globalInstanceId", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("msg", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("otherData", array$Ljava$lang$String == null ? (array$Ljava$lang$String = CommonBaseEventImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), new ObjectStreamField("elapsedTime", Long.TYPE), new ObjectStreamField("severity", Short.TYPE), new ObjectStreamField("creationTimeValue", Long.TYPE), new ObjectStreamField("creationTime", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("priority", Short.TYPE), new ObjectStreamField("situationType", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("repeatCount", Short.TYPE), new ObjectStreamField("sequenceNumber", Long.TYPE), new ObjectStreamField("msgDataElement", class$org$eclipse$hyades$logging$events$IMsgDataElement == null ? (class$org$eclipse$hyades$logging$events$IMsgDataElement = CommonBaseEventImpl.class$("org.eclipse.hyades.logging.events.IMsgDataElement")) : class$org$eclipse$hyades$logging$events$IMsgDataElement), new ObjectStreamField("reporterComponentId", class$org$eclipse$hyades$logging$events$IComponentIdentification == null ? (class$org$eclipse$hyades$logging$events$IComponentIdentification = CommonBaseEventImpl.class$("org.eclipse.hyades.logging.events.IComponentIdentification")) : class$org$eclipse$hyades$logging$events$IComponentIdentification), new ObjectStreamField("sourceComponentId", class$org$eclipse$hyades$logging$events$IComponentIdentification == null ? (class$org$eclipse$hyades$logging$events$IComponentIdentification = CommonBaseEventImpl.class$("org.eclipse.hyades.logging.events.IComponentIdentification")) : class$org$eclipse$hyades$logging$events$IComponentIdentification), new ObjectStreamField("contextDataElements", array$Lorg$eclipse$hyades$logging$events$IContextDataElement == null ? (array$Lorg$eclipse$hyades$logging$events$IContextDataElement = CommonBaseEventImpl.class$("[Lorg.eclipse.hyades.logging.events.IContextDataElement;")) : array$Lorg$eclipse$hyades$logging$events$IContextDataElement), new ObjectStreamField("extendedDataElements", array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement == null ? (array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement = CommonBaseEventImpl.class$("[Lorg.eclipse.hyades.logging.events.IExtendedDataElement;")) : array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement), new ObjectStreamField("associatedEvents", array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent == null ? (array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent = CommonBaseEventImpl.class$("[Lorg.eclipse.hyades.logging.events.IAssociatedEvent;")) : array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent), new ObjectStreamField("anyElements", array$Lorg$eclipse$hyades$logging$events$ICommonBaseEventAnyElement == null ? (array$Lorg$eclipse$hyades$logging$events$ICommonBaseEventAnyElement = CommonBaseEventImpl.class$("[Lorg.eclipse.hyades.logging.events.ICommonBaseEventAnyElement;")) : array$Lorg$eclipse$hyades$logging$events$ICommonBaseEventAnyElement), new ObjectStreamField("situation", class$org$eclipse$hyades$logging$events$ISituation == null ? (class$org$eclipse$hyades$logging$events$ISituation = CommonBaseEventImpl.class$("org.eclipse.hyades.logging.events.ISituation")) : class$org$eclipse$hyades$logging$events$ISituation), new ObjectStreamField("version", class$java$lang$String == null ? (class$java$lang$String = CommonBaseEventImpl.class$("java.lang.String")) : class$java$lang$String)};
    private String version = "1.0.1";
    protected IMsgDataElement msgDataElement = null;
    protected IComponentIdentification reporterComponentId = null;
    protected IComponentIdentification sourceComponentId = null;
    protected ArrayList contextDataElements = null;
    protected ArrayList extendedDataElements = null;
    protected ArrayList associatedEvents = null;
    protected ArrayList anyElements = null;
    protected ISituation situation = null;
    protected String extensionName = null;
    protected String localInstanceId = null;
    protected String globalInstanceId = SimpleEventFactoryImpl.getInstance().createGlobalInstanceId();
    protected String creationTime = null;
    protected String msg = null;
    protected String[] otherData = null;
    protected long creationTimeValue = 0L;
    protected long elapsedTime = 0L;
    protected short severity = 0;
    protected short priority = 0;
    protected short repeatCount = 0;
    protected long sequenceNumber = 0L;
    private boolean creationTimeIsSet = false;
    private boolean elapsedTimeIsSet = false;
    private boolean severityIsSet = false;
    private boolean priorityIsSet = false;
    private boolean repeatCountIsSet = false;
    private boolean sequenceNumberIsSet = false;
    protected String situationType = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$IMsgDataElement;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$IComponentIdentification;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IContextDataElement;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IExtendedDataElement;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$IAssociatedEvent;
    static /* synthetic */ Class array$Lorg$eclipse$hyades$logging$events$ICommonBaseEventAnyElement;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$ISituation;

    protected CommonBaseEventImpl() {
    }

    public void addContextDataElement(IContextDataElement iContextDataElement) {
        if (this.contextDataElements == null) {
            this.contextDataElements = new ArrayList();
        }
        this.contextDataElements.add(iContextDataElement);
    }

    public void addExtendedDataElement(IExtendedDataElement iExtendedDataElement) {
        if (this.extendedDataElements == null) {
            this.extendedDataElements = new ArrayList();
        }
        this.extendedDataElements.add(iExtendedDataElement);
    }

    public void addAssociatedEvent(IAssociatedEvent iAssociatedEvent) {
        String string = null;
        IAssociationEngine iAssociationEngine = iAssociatedEvent.getAssociationEngineInfo();
        if (iAssociationEngine != null) {
            string = iAssociationEngine.getName();
        }
        if (string == null) {
            string = iAssociatedEvent.getAssociationEngine();
        }
        if (string != null) {
            if (this.associatedEvents == null) {
                this.associatedEvents = new ArrayList();
            }
        } else {
            throw new RuntimeException("IAssociatedEvent must be assigned an AssociatineEngine to add it to an instance of ICommonBaseEvent");
        }
        this.associatedEvents.add(iAssociatedEvent);
    }

    public List getContextDataElements() {
        if (this.contextDataElements == null) {
            this.contextDataElements = new ArrayList();
        }
        return this.contextDataElements;
    }

    public List getExtendedDataElements() {
        if (this.extendedDataElements == null) {
            this.extendedDataElements = new ArrayList();
        }
        return this.extendedDataElements;
    }

    public List getAssociatedEvents() {
        if (this.associatedEvents == null) {
            this.associatedEvents = new ArrayList();
        }
        return this.associatedEvents;
    }

    public IContextDataElement getContextDataElement(String string) {
        if (this.contextDataElements != null) {
            int n = 0;
            while (n < this.contextDataElements.size()) {
                if (((IContextDataElement)this.contextDataElements.get(n)).getName().equals(string)) {
                    return (IContextDataElement)this.contextDataElements.get(n);
                }
                ++n;
            }
        }
        return null;
    }

    public IExtendedDataElement getExtendedDataElement(String string) {
        if (this.extendedDataElements != null) {
            int n = 0;
            while (n < this.extendedDataElements.size()) {
                if (((IExtendedDataElement)this.extendedDataElements.get(n)).getName().equals(string)) {
                    return (IExtendedDataElement)this.extendedDataElements.get(n);
                }
                ++n;
            }
        }
        return null;
    }

    public void removeContextDataElement(String string) {
        if (this.contextDataElements != null) {
            int n = 0;
            while (n < this.contextDataElements.size()) {
                if (((IContextDataElement)this.contextDataElements.get(n)).getName().equals(string)) {
                    this.contextDataElements.remove(n--);
                }
                ++n;
            }
        }
    }

    public void removeExtendedDataElement(String string) {
        if (this.extendedDataElements != null) {
            int n = 0;
            while (n < this.extendedDataElements.size()) {
                if (((IExtendedDataElement)this.extendedDataElements.get(n)).getName().equals(string)) {
                    this.extendedDataElements.remove(n--);
                }
                ++n;
            }
        }
    }

    public void clearAssociatedEvents() {
        this.associatedEvents = null;
    }

    public void clearContextDataElements() {
        this.contextDataElements = null;
    }

    public void clearExtendedDataElements() {
        this.extendedDataElements = null;
    }

    public void addAnyElement(ICommonBaseEventAnyElement iCommonBaseEventAnyElement) {
        if (this.anyElements == null) {
            this.anyElements = new ArrayList();
        }
        this.anyElements.add(iCommonBaseEventAnyElement);
    }

    public List getAnyElements() {
        if (this.anyElements == null) {
            this.anyElements = new ArrayList();
        }
        return this.anyElements;
    }

    public ICommonBaseEventAnyElement getAnyElement(String string) {
        if (this.anyElements != null) {
            int n = 0;
            while (n < this.anyElements.size()) {
                if (((ICommonBaseEventAnyElement)this.anyElements.get(n)).getElementName().equals(string)) {
                    return (ICommonBaseEventAnyElement)this.anyElements.get(n);
                }
                ++n;
            }
        }
        return null;
    }

    public void removeAnyElement(String string) {
        if (this.anyElements != null) {
            int n = 0;
            while (n < this.anyElements.size()) {
                if (((ICommonBaseEventAnyElement)this.anyElements.get(n)).getElementName().equals(string)) {
                    this.anyElements.remove(n--);
                }
                ++n;
            }
        }
    }

    public void clearAnyElements() {
        this.anyElements = null;
    }

    public String getCreationTime() {
        if (this.creationTime == null && this.creationTimeValue > 0L) {
            this.creationTime = CbeFormatter.convertDateToXmlSchemaDateTime(this.creationTimeValue);
        }
        return this.creationTime;
    }

    public long getCreationTimeAsLong() {
        if (this.creationTimeValue == 0L && this.creationTime != null) {
            this.creationTimeValue = CbeFormatter.convertXmlSchemaDateTimeToDate(this.creationTime);
        }
        return this.creationTimeValue;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getGlobalInstanceId() {
        return this.globalInstanceId;
    }

    public String getLocalInstanceId() {
        return this.localInstanceId;
    }

    public String getMsg() {
        return this.msg;
    }

    public short getPriority() {
        return this.priority;
    }

    public short getRepeatCount() {
        return this.repeatCount;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getSeverity() {
        return this.severity;
    }

    public String getSituationType() {
        return this.situationType;
    }

    public IComponentIdentification getSourceComponentId() {
        return this.sourceComponentId;
    }

    public IMsgDataElement getMsgDataElement() {
        return this.msgDataElement;
    }

    public String[] getOtherData() {
        return this.otherData;
    }

    public IComponentIdentification getReporterComponentId() {
        return this.reporterComponentId;
    }

    public ISituation getSituation() {
        return this.situation;
    }

    public List getVersions() {
        return Arrays.asList("1.0", "1.0.1");
    }

    public void setPreferredVersion(String string) throws UnsupportedVersionException {
        if (!string.equals("1.0") && !string.equals("1.0.1")) {
            throw new UnsupportedVersionException("Invalid preferred version (".concat(string).concat(")."));
        }
        this.version = string;
    }

    public void setCreationTime(String string) {
        this.creationTime = string;
        this.creationTimeIsSet = true;
        this.creationTimeValue = 0L;
    }

    public void setCreationTime(long l) {
        this.creationTimeValue = l;
        this.creationTimeIsSet = true;
        this.creationTime = null;
    }

    public void setElapsedTime(long l) {
        this.elapsedTime = l;
        this.elapsedTimeIsSet = true;
    }

    public void setExtensionName(String string) {
        this.extensionName = string;
    }

    public void setGlobalInstanceId(String string) {
        this.globalInstanceId = string;
    }

    public void setLocalInstanceId(String string) {
        this.localInstanceId = string;
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public void setOtherData(String[] stringArray) {
        this.otherData = stringArray;
    }

    public void setPriority(short s) {
        this.priority = s;
        this.priorityIsSet = true;
    }

    public void setRepeatCount(short s) {
        this.repeatCount = s;
        this.repeatCountIsSet = true;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
        this.sequenceNumberIsSet = true;
    }

    public void setSeverity(short s) {
        this.severity = s;
        this.severityIsSet = true;
    }

    public void setSituationType(String string) {
        this.situationType = string;
    }

    public void setSourceComponentId(IComponentIdentification iComponentIdentification) {
        this.sourceComponentId = iComponentIdentification;
    }

    public void setMsgDataElement(IMsgDataElement iMsgDataElement) {
        this.msgDataElement = iMsgDataElement;
    }

    public void setReporterComponentId(IComponentIdentification iComponentIdentification) {
        this.reporterComponentId = iComponentIdentification;
    }

    public void setSituation(ISituation iSituation) {
        this.situation = iSituation;
    }

    public void init() {
        this.version = "1.0.1";
        this.unsetCreationTime();
        this.unsetElapsedTime();
        this.unsetPriority();
        this.unsetRepeatCount();
        this.unsetSequenceNumber();
        this.unsetSeverity();
        this.associatedEvents = null;
        this.contextDataElements = null;
        this.extendedDataElements = null;
        this.anyElements = null;
        this.sourceComponentId = null;
        this.reporterComponentId = null;
        this.msgDataElement = null;
        this.situation = null;
        this.extensionName = null;
        this.localInstanceId = null;
        this.situationType = null;
        this.msg = null;
        this.otherData = null;
        this.globalInstanceId = SimpleEventFactoryImpl.getInstance().createGlobalInstanceId();
    }

    public String externalizeCanonicalXmlString() {
        return CbeFormatter.toCanonicalXMLString(this);
    }

    public String externalizeCanonicalXmlDocString() {
        return CbeFormatter.toCanonicalXMLDocString(this);
    }

    public void internalizeCanonicalXmlString(String string) {
        CbeFormatter.fromCanonicalXMLString(this, string);
    }

    public void internalizeCanonicalXmlDocString(String string) {
        CbeFormatter.fromCanonicalXMLDocString(this, string);
    }

    public String getCommonBaseEventImplVersion() {
        return this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEventSchemaVersion() {
        return CbeFormatter.getEventFormatterVersion();
    }

    public String toString() {
        return CbeFormatter.toCanonicalXMLString(this);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof CommonBaseEventImpl && this.getClass() == object.getClass()) {
            CommonBaseEventImpl commonBaseEventImpl = (CommonBaseEventImpl)object;
            String[] stringArray = this.getGlobalInstanceId();
            String[] stringArray2 = commonBaseEventImpl.getGlobalInstanceId();
            if ((stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) && this.getCreationTimeAsLong() == commonBaseEventImpl.getCreationTimeAsLong() && this.getElapsedTime() == commonBaseEventImpl.getElapsedTime() && this.getSeverity() == commonBaseEventImpl.getSeverity() && this.getPriority() == commonBaseEventImpl.getPriority() && this.getRepeatCount() == commonBaseEventImpl.getRepeatCount() && this.getSequenceNumber() == commonBaseEventImpl.getSequenceNumber()) {
                stringArray = this.getLocalInstanceId();
                stringArray2 = commonBaseEventImpl.getLocalInstanceId();
                if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                    stringArray = this.getVersion();
                    stringArray2 = commonBaseEventImpl.getVersion();
                    if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                        stringArray = this.getExtensionName();
                        stringArray2 = commonBaseEventImpl.getExtensionName();
                        if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                            stringArray = this.getSituationType();
                            stringArray2 = commonBaseEventImpl.getSituationType();
                            if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                                stringArray = this.getMsg();
                                stringArray2 = commonBaseEventImpl.getMsg();
                                if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                                    stringArray = this.getMsgDataElement();
                                    stringArray2 = commonBaseEventImpl.getMsgDataElement();
                                    if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                                        stringArray = this.getSituation();
                                        stringArray2 = commonBaseEventImpl.getSituation();
                                        if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                                            stringArray = this.getReporterComponentId();
                                            stringArray2 = commonBaseEventImpl.getReporterComponentId();
                                            if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                                                stringArray = this.getSourceComponentId();
                                                stringArray2 = commonBaseEventImpl.getSourceComponentId();
                                                if (stringArray != null && stringArray.equals(stringArray2) || stringArray == null && stringArray2 == null) {
                                                    ArrayList arrayList = this.contextDataElements;
                                                    ArrayList arrayList2 = commonBaseEventImpl.contextDataElements;
                                                    if (arrayList != null && arrayList.equals(arrayList2) || (arrayList == null || arrayList.size() == 0) && (arrayList2 == null || arrayList2.size() == 0)) {
                                                        arrayList = this.extendedDataElements;
                                                        arrayList2 = commonBaseEventImpl.extendedDataElements;
                                                        if (arrayList != null && arrayList.equals(arrayList2) || (arrayList == null || arrayList.size() == 0) && (arrayList2 == null || arrayList2.size() == 0)) {
                                                            arrayList = this.associatedEvents;
                                                            arrayList2 = commonBaseEventImpl.associatedEvents;
                                                            if (arrayList != null && arrayList.equals(arrayList2) || (arrayList == null || arrayList.size() == 0) && (arrayList2 == null || arrayList2.size() == 0)) {
                                                                arrayList = this.anyElements;
                                                                arrayList2 = commonBaseEventImpl.anyElements;
                                                                if (arrayList != null && arrayList.equals(arrayList2) || (arrayList == null || arrayList.size() == 0) && (arrayList2 == null || arrayList2.size() == 0)) {
                                                                    stringArray = this.getOtherData();
                                                                    stringArray2 = commonBaseEventImpl.getOtherData();
                                                                    if (stringArray == null && stringArray2 == null) {
                                                                        bl = true;
                                                                    } else if (stringArray != null && stringArray2 != null && stringArray.length == stringArray2.length) {
                                                                        bl = true;
                                                                        int n = 0;
                                                                        while (n < stringArray.length) {
                                                                            if (!stringArray[n].equals(stringArray2[n])) {
                                                                                bl = false;
                                                                                break;
                                                                            }
                                                                            ++n;
                                                                        }
                                                                    } else {
                                                                        bl = false;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("extensionName", this.extensionName);
        putField.put("localInstanceId", this.localInstanceId);
        putField.put("globalInstanceId", this.globalInstanceId);
        putField.put("msg", this.msg);
        putField.put("otherData", this.otherData);
        putField.put("elapsedTime", this.elapsedTime);
        putField.put("version", this.version);
        putField.put("severity", this.severity);
        putField.put("creationTimeValue", this.creationTimeValue);
        putField.put("creationTime", this.creationTime);
        putField.put("priority", this.priority);
        putField.put("situationType", this.situationType);
        putField.put("repeatCount", this.repeatCount);
        putField.put("sequenceNumber", this.sequenceNumber);
        putField.put("sourceComponentId", this.sourceComponentId);
        if (this.msgDataElement != null) {
            putField.put("msgDataElement", this.msgDataElement);
        }
        if (this.situation != null) {
            putField.put("situation", this.situation);
        }
        if (this.reporterComponentId != null) {
            putField.put("reporterComponentId", this.reporterComponentId);
        }
        if (this.contextDataElements != null && !this.contextDataElements.isEmpty()) {
            putField.put("contextDataElements", this.contextDataElements.toArray(new IContextDataElement[this.contextDataElements.size()]));
        }
        if (this.extendedDataElements != null && !this.extendedDataElements.isEmpty()) {
            putField.put("extendedDataElements", this.extendedDataElements.toArray(new IExtendedDataElement[this.extendedDataElements.size()]));
        }
        if (this.associatedEvents != null && !this.associatedEvents.isEmpty()) {
            putField.put("associatedEvents", this.associatedEvents.toArray(new IAssociatedEvent[this.associatedEvents.size()]));
        }
        if (this.anyElements != null && !this.anyElements.isEmpty()) {
            ICommonBaseEventAnyElement[] iCommonBaseEventAnyElementArray = this.anyElements.toArray(new ICommonBaseEventAnyElement[this.anyElements.size()]);
            int n = iCommonBaseEventAnyElementArray.length;
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = iCommonBaseEventAnyElementArray[n2].getXmlAnyElement();
                ++n2;
            }
            putField.put("anyElements", stringArray);
        }
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        int n;
        int n2;
        ObjectInputStream.GetField getField = null;
        getField = objectInputStream.readFields();
        this.extensionName = (String)getField.get("extensionName", this.extensionName);
        this.localInstanceId = (String)getField.get("localInstanceId", this.localInstanceId);
        this.globalInstanceId = (String)getField.get("globalInstanceId", this.globalInstanceId);
        this.msg = (String)getField.get("msg", this.msg);
        this.otherData = (String[])getField.get("otherData", this.otherData);
        this.elapsedTime = getField.get("elapsedTime", this.elapsedTime);
        this.version = (String)getField.get("version", this.version);
        this.severity = getField.get("severity", this.severity);
        this.creationTime = (String)getField.get("creationTime", this.creationTime);
        this.creationTimeValue = getField.get("creationTimeValue", this.creationTimeValue);
        this.priority = getField.get("priority", this.priority);
        this.situationType = (String)getField.get("situationType", this.situationType);
        this.repeatCount = getField.get("repeatCount", this.repeatCount);
        this.sequenceNumber = getField.get("sequenceNumber", this.sequenceNumber);
        this.msgDataElement = (IMsgDataElement)getField.get("msgDataElement", this.msgDataElement);
        this.situation = (ISituation)getField.get("situation", this.situation);
        this.reporterComponentId = (IComponentIdentification)getField.get("reporterComponentId", this.reporterComponentId);
        this.sourceComponentId = (IComponentIdentification)getField.get("sourceComponentId", this.sourceComponentId);
        Object[] objectArray = null;
        objectArray = (Object[])getField.get("contextDataElements", null);
        if (objectArray != null) {
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                this.addContextDataElement((IContextDataElement)objectArray[n]);
                ++n;
            }
        }
        objectArray = null;
        objectArray = (Object[])getField.get("extendedDataElements", null);
        if (objectArray != null) {
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                object = (IExtendedDataElement)objectArray[n];
                this.addExtendedDataElement((IExtendedDataElement)object);
                ++n;
            }
        }
        objectArray = null;
        objectArray = (Object[])getField.get("associatedEvents", null);
        if (objectArray != null) {
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                this.addAssociatedEvent((IAssociatedEvent)objectArray[n]);
                ++n;
            }
        }
        objectArray = null;
        objectArray = (Object[])getField.get("anyElements", null);
        if (objectArray != null) {
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                object = new CommonBaseEventAnyElementImpl();
                try {
                    object.setXmlAnyElement((String)objectArray[n]);
                }
                catch (InvalidXMLAnyElementException invalidXMLAnyElementException) {
                    throw new IOException(invalidXMLAnyElementException.getMessage());
                }
                this.addAnyElement((ICommonBaseEventAnyElement)object);
                ++n;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        CommonBaseEventImpl commonBaseEventImpl = (CommonBaseEventImpl)super.clone();
        Object var2_2 = null;
        if (this.contextDataElements != null) {
            commonBaseEventImpl.contextDataElements = (ArrayList)this.contextDataElements.clone();
            n = 0;
            while (n < this.contextDataElements.size()) {
                var2_2 = this.contextDataElements.get(n);
                if (var2_2 instanceof ContextDataElementImpl) {
                    commonBaseEventImpl.contextDataElements.set(n, (IContextDataElement)((ContextDataElementImpl)var2_2).clone());
                }
                ++n;
            }
        }
        if (this.extendedDataElements != null) {
            commonBaseEventImpl.extendedDataElements = (ArrayList)this.extendedDataElements.clone();
            n = 0;
            while (n < this.extendedDataElements.size()) {
                var2_2 = this.extendedDataElements.get(n);
                if (var2_2 instanceof ExtendedDataElementImpl) {
                    commonBaseEventImpl.extendedDataElements.set(n, (IExtendedDataElement)((ExtendedDataElementImpl)var2_2).clone());
                }
                ++n;
            }
        }
        if (this.anyElements != null) {
            commonBaseEventImpl.anyElements = (ArrayList)this.anyElements.clone();
            n = 0;
            while (n < this.anyElements.size()) {
                var2_2 = this.anyElements.get(n);
                if (var2_2 instanceof CommonBaseEventAnyElementImpl) {
                    commonBaseEventImpl.anyElements.set(n, (ICommonBaseEventAnyElement)((CommonBaseEventAnyElementImpl)var2_2).clone());
                }
                ++n;
            }
        }
        if (this.associatedEvents != null) {
            commonBaseEventImpl.associatedEvents = (ArrayList)this.associatedEvents.clone();
            n = 0;
            while (n < this.associatedEvents.size()) {
                var2_2 = this.associatedEvents.get(n);
                if (var2_2 instanceof AssociatedEventImpl) {
                    commonBaseEventImpl.associatedEvents.set(n, (IAssociatedEvent)((AssociatedEventImpl)var2_2).clone());
                }
                ++n;
            }
        }
        if (this.msgDataElement instanceof MsgDataElementImpl) {
            commonBaseEventImpl.msgDataElement = (IMsgDataElement)((MsgDataElementImpl)this.msgDataElement).clone();
        }
        if (this.situation instanceof SituationImpl) {
            commonBaseEventImpl.situation = (ISituation)((SituationImpl)this.situation).clone();
        }
        if (this.sourceComponentId instanceof ComponentIdentificationImpl) {
            commonBaseEventImpl.sourceComponentId = (IComponentIdentification)((ComponentIdentificationImpl)this.sourceComponentId).clone();
        }
        if (this.reporterComponentId instanceof ComponentIdentificationImpl) {
            commonBaseEventImpl.reporterComponentId = (IComponentIdentification)((ComponentIdentificationImpl)this.reporterComponentId).clone();
        }
        if (this.otherData != null) {
            commonBaseEventImpl.otherData = (String[])this.otherData.clone();
        }
        return commonBaseEventImpl;
    }

    public IAssociatedEvent addAssociatedEvent(String string, String string2, String string3, String[] stringArray) {
        AssociationEngineImpl associationEngineImpl = new AssociationEngineImpl();
        associationEngineImpl.setName(string);
        associationEngineImpl.setType(string2);
        associationEngineImpl.setId(string3);
        AssociatedEventImpl associatedEventImpl = new AssociatedEventImpl();
        associatedEventImpl.setAssociationEngineInfo(associationEngineImpl);
        associatedEventImpl.setResolvedEventsAsArray(stringArray);
        this.addAssociatedEvent(associatedEventImpl);
        return associatedEventImpl;
    }

    public IContextDataElement addContextDataElementWithId(String string, String string2, String string3) {
        ContextDataElementImpl contextDataElementImpl = new ContextDataElementImpl();
        contextDataElementImpl.setType(string);
        contextDataElementImpl.setName(string2);
        contextDataElementImpl.setContextId(string3);
        this.addContextDataElement(contextDataElementImpl);
        return contextDataElementImpl;
    }

    public IContextDataElement addContextDataElementWithValue(String string, String string2, String string3) {
        ContextDataElementImpl contextDataElementImpl = new ContextDataElementImpl();
        contextDataElementImpl.setType(string);
        contextDataElementImpl.setName(string2);
        contextDataElementImpl.setContextValue(string3);
        this.addContextDataElement(contextDataElementImpl);
        return contextDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElement(String string, int n, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(n);
        extendedDataElementImpl.setValues(new String[]{string2});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElement(String string, int n, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(n);
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElement(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(6);
        extendedDataElementImpl.setValues(new String[]{string2});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElement(String string, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(15);
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithByteArrayValue(String string, byte[] byArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(9);
        String[] stringArray = new String[byArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(byArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithByteValue(String string, byte by) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(0);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(by)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithBooleanArrayValue(String string, boolean[] blArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(16);
        String[] stringArray = new String[blArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(blArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithBooleanValue(String string, boolean bl) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(7);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(bl)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithDateArrayValue(String string, String[] stringArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(17);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = String.valueOf(stringArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray2);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithDateAsLongValue(String string, long l) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(8);
        extendedDataElementImpl.setValues(new String[]{CbeFormatter.convertDateToXmlSchemaDateTime(l)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithDatesAsLongValue(String string, long[] lArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(17);
        String[] stringArray = new String[lArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = CbeFormatter.convertDateToXmlSchemaDateTime(lArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithDateValue(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(8);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(string2)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithDoubleArrayValue(String string, double[] dArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(14);
        String[] stringArray = new String[dArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(dArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithDoubleValue(String string, double d) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(5);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(d)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithFloatArrayValue(String string, float[] fArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(13);
        String[] stringArray = new String[fArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(fArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithFloatValue(String string, float f) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(4);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(f)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithHexValue(String string, byte[] byArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(18);
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)(byArray[n] + 128);
            ++n;
        }
        extendedDataElementImpl.setHexValues(cArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithHexValue(String string, String string2) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(18);
        char[] cArray = new char[string2.length()];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = string2.charAt(n);
            ++n;
        }
        extendedDataElementImpl.setHexValues(cArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithIntArrayValue(String string, int[] nArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(11);
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(nArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithIntValue(String string, int n) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(2);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(n)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithLongArrayValue(String string, long[] lArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(12);
        String[] stringArray = new String[lArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(lArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithLongValue(String string, long l) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(3);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(l)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithShortArrayValue(String string, short[] sArray) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(10);
        String[] stringArray = new String[sArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(sArray[n]);
            ++n;
        }
        extendedDataElementImpl.setValues(stringArray);
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public IExtendedDataElement addExtendedDataElementWithShortValue(String string, short s) {
        ExtendedDataElementImpl extendedDataElementImpl = new ExtendedDataElementImpl();
        extendedDataElementImpl.setName(string);
        extendedDataElementImpl.setType(1);
        extendedDataElementImpl.setValues(new String[]{String.valueOf(s)});
        this.addExtendedDataElement(extendedDataElementImpl);
        return extendedDataElementImpl;
    }

    public boolean isSetCreationTime() {
        return this.creationTimeIsSet;
    }

    public boolean isSetElapsedTime() {
        return this.elapsedTimeIsSet;
    }

    public boolean isSetPriority() {
        return this.priorityIsSet;
    }

    public boolean isSetRepeatCount() {
        return this.repeatCountIsSet;
    }

    public boolean isSetSequenceNumber() {
        return this.sequenceNumberIsSet;
    }

    public boolean isSetSeverity() {
        return this.severityIsSet;
    }

    public IMsgDataElement setMsgDataElement(String string, String string2, IMsgCatalogToken[] iMsgCatalogTokenArray, String string3, String string4, String string5, String string6) {
        MsgDataElementImpl msgDataElementImpl = new MsgDataElementImpl();
        msgDataElementImpl.setMsgCatalog(string);
        msgDataElementImpl.setMsgCatalogId(string2);
        msgDataElementImpl.setMsgCatalogTokens(iMsgCatalogTokenArray);
        msgDataElementImpl.setMsgCatalogType(string3);
        msgDataElementImpl.setMsgId(string4);
        msgDataElementImpl.setMsgIdType(string5);
        msgDataElementImpl.setMsgLocale(string6);
        this.setMsgDataElement(msgDataElementImpl);
        return msgDataElementImpl;
    }

    public IMsgDataElement setMsgDataElement(String string, String string2, String[] stringArray, String string3, String string4, String string5, String string6) {
        MsgDataElementImpl msgDataElementImpl = new MsgDataElementImpl();
        msgDataElementImpl.setMsgCatalog(string);
        msgDataElementImpl.setMsgCatalogId(string2);
        msgDataElementImpl.setMsgCatalogTokensAsStrings(stringArray);
        msgDataElementImpl.setMsgCatalogType(string3);
        msgDataElementImpl.setMsgId(string4);
        msgDataElementImpl.setMsgIdType(string5);
        msgDataElementImpl.setMsgLocale(string6);
        this.setMsgDataElement(msgDataElementImpl);
        return msgDataElementImpl;
    }

    public IComponentIdentification setReporterComponentId(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        ComponentIdentificationImpl componentIdentificationImpl = new ComponentIdentificationImpl();
        componentIdentificationImpl.setApplication(string);
        componentIdentificationImpl.setComponent(string2);
        componentIdentificationImpl.setSubComponent(string3);
        componentIdentificationImpl.setComponentType(string4);
        componentIdentificationImpl.setComponentIdType(string5);
        componentIdentificationImpl.setExecutionEnvironment(string6);
        componentIdentificationImpl.setInstanceId(string7);
        componentIdentificationImpl.setLocation(string8);
        componentIdentificationImpl.setLocationType(string9);
        componentIdentificationImpl.setProcessId(string10);
        componentIdentificationImpl.setThreadId(string11);
        this.setReporterComponentId(componentIdentificationImpl);
        return componentIdentificationImpl;
    }

    public IComponentIdentification setReporterComponentId(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ComponentIdentificationImpl componentIdentificationImpl = new ComponentIdentificationImpl();
        componentIdentificationImpl.setApplication(string);
        componentIdentificationImpl.setComponent(string2);
        componentIdentificationImpl.setSubComponent(string3);
        componentIdentificationImpl.setComponentType(string4);
        componentIdentificationImpl.setComponentIdType(string5);
        componentIdentificationImpl.setLocation(string6);
        componentIdentificationImpl.setLocationType(string7);
        this.setReporterComponentId(componentIdentificationImpl);
        return componentIdentificationImpl;
    }

    public IComponentIdentification setSourceComponentId(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        ComponentIdentificationImpl componentIdentificationImpl = new ComponentIdentificationImpl();
        componentIdentificationImpl.setApplication(string);
        componentIdentificationImpl.setComponent(string2);
        componentIdentificationImpl.setSubComponent(string3);
        componentIdentificationImpl.setComponentType(string4);
        componentIdentificationImpl.setComponentIdType(string5);
        componentIdentificationImpl.setExecutionEnvironment(string6);
        componentIdentificationImpl.setInstanceId(string7);
        componentIdentificationImpl.setLocation(string8);
        componentIdentificationImpl.setLocationType(string9);
        componentIdentificationImpl.setProcessId(string10);
        componentIdentificationImpl.setThreadId(string11);
        this.setSourceComponentId(componentIdentificationImpl);
        return componentIdentificationImpl;
    }

    public IComponentIdentification setSourceComponentId(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ComponentIdentificationImpl componentIdentificationImpl = new ComponentIdentificationImpl();
        componentIdentificationImpl.setApplication(string);
        componentIdentificationImpl.setComponent(string2);
        componentIdentificationImpl.setSubComponent(string3);
        componentIdentificationImpl.setComponentType(string4);
        componentIdentificationImpl.setComponentIdType(string5);
        componentIdentificationImpl.setLocation(string6);
        componentIdentificationImpl.setLocationType(string7);
        this.setSourceComponentId(componentIdentificationImpl);
        return componentIdentificationImpl;
    }

    public void unsetCreationTime() {
        this.creationTimeValue = 0L;
        this.creationTime = null;
        this.creationTimeIsSet = false;
    }

    public void unsetElapsedTime() {
        this.elapsedTimeIsSet = false;
    }

    public void unsetPriority() {
        this.priorityIsSet = false;
    }

    public void unsetRepeatCount() {
        this.repeatCountIsSet = false;
    }

    public void unsetSequenceNumber() {
        this.sequenceNumberIsSet = false;
    }

    public void unsetSeverity() {
        this.severityIsSet = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

