/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.PerfmonLoader;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.perfmon.StatisticalXMLTranslator;
import org.eclipse.hyades.perfmon.xml.XMLParser;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;

public class PerfmonCustomLoader
extends PerfmonLoader
implements DataProcessor {
    ArrayList listeners = new ArrayList();
    long started;
    String tracename;
    Node node;
    Process process;
    Agent agent;
    TRCAgent trcagent;
    boolean running = false;
    XMLParser parser = new XMLParser();
    StatisticalXMLTranslator translator;

    public PerfmonCustomLoader(long l, TRCAgent tRCAgent, String string, String string2, int n, String string3, int n2) throws Exception {
        this.started = l;
        this.init(string, tRCAgent, string2, n, string3, n2);
    }

    public PerfmonCustomLoader(long l, TRCAgent tRCAgent, String string, String string2, String string3, int n) throws Exception {
        this.started = l;
        this.init(string, tRCAgent, string2, 10002, string3, n);
    }

    public void killProcess() throws Exception {
        this.node.killProcess(this.process);
    }

    public void setFrequency(int n) throws IOException {
        this.setNVPair("var_int", "DC_WAITTIME", "" + n);
    }

    public void setRemoteHost(String string) throws IOException {
        if (string.length() == 0) {
            string = "NULL";
        }
        PerfmonPlugin.DBG.info("Setting remote host to " + string);
        this.setNVPair("var_string", "PERFMON_REG_HOST", string);
    }

    public void getUpdatedTree() throws IOException {
        this.setNVPair("updatetree", "", "true");
    }

    public void getUpdatedTree(SDDescriptor sDDescriptor) throws IOException {
        if (sDDescriptor.getId() == null) {
            return;
        }
        PerfmonPlugin.DBG.info("Requesting tree update for descriptor " + sDDescriptor.getName() + " (" + sDDescriptor.getId() + ")");
        this.setNVPair("updatetree", sDDescriptor.getId(), "true");
    }

    public void counterON(SDDescriptor sDDescriptor) throws IOException, NullPointerException {
        String string = this.translator.getID(sDDescriptor);
        if (string == null) {
            throw new NullPointerException("descriptor ID not found");
        }
        this.setNVPair("filter", string, "true");
    }

    public void counterOFF(SDDescriptor sDDescriptor) throws IOException {
        String string = this.translator.getID(sDDescriptor);
        if (string == null) {
            throw new IOException("descriptor ID not found");
        }
        this.setNVPair("filter", string, "false");
    }

    public SDDescriptor getModel() {
        return this.translator.getModel();
    }

    public void addLoaderListener(StatisticalLoaderListener statisticalLoaderListener) {
        this.translator.addLoaderListener(statisticalLoaderListener);
    }

    public void removeLoaderListener(StatisticalLoaderListener statisticalLoaderListener) {
        this.translator.addLoaderListener(statisticalLoaderListener);
    }

    private Agent findAgent(Node node) throws NotConnectedException {
        Agent agent = null;
        Enumeration enumeration = node.listProcesses();
        while (enumeration.hasMoreElements()) {
            Process process = (Process)enumeration.nextElement();
            PerfmonPlugin.DBG.info("checking RAC process " + process.getName());
            agent = this.findAgent(process);
            if (agent != null) break;
        }
        return agent;
    }

    private Agent findAgent(Process process) {
        if (process == null) {
            return null;
        }
        Enumeration enumeration = process.listAgents();
        Agent agent = null;
        if (!enumeration.hasMoreElements()) {
            PerfmonPlugin.DBG.info("found no agents in this process");
        }
        while (enumeration.hasMoreElements()) {
            Agent agent2 = (Agent)enumeration.nextElement();
            PerfmonPlugin.DBG.info("found RAC agent " + agent2.getName() + "/" + agent2.getType());
            if (!agent2.getName().startsWith("PerfmonAgent") && !agent2.getType().startsWith("PerfmonAgent")) continue;
            try {
                if (agent2.isAttached()) continue;
                this.process = process;
                agent = agent2;
                PerfmonPlugin.DBG.info("agent not attached - accepting");
                break;
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.warning("error checking agent " + exception);
            }
        }
        return agent;
    }

    private void init(String string, TRCAgent tRCAgent, String string2, int n, String string3, int n2) throws Exception {
        block10: {
            this.trcagent = tRCAgent;
            this.tracename = string;
            this.translator = new StatisticalXMLTranslator(tRCAgent, this.tracename);
            if (tRCAgent != null) {
                this.translator.getModel().setAgent(tRCAgent);
            }
            PerfmonPlugin.DBG.warning("asked to connect to " + string2 + ":" + n);
            try {
                this.node = NodeFactory.createNode((String)string2);
                PerfmonPlugin.DBG.info("connecting to RAC");
                this.node.connect(n);
                PerfmonPlugin.DBG.info("connected to RAC");
                this.agent = this.findAgent(this.node);
                if (this.agent == null) {
                    PerfmonPlugin.DBG.info("Launching RAC PerfmonAgent");
                    this.process = ProcessFactory.createProcess((Node)this.node, (String)"PerfmonAgent");
                    if (this.process != null) {
                        ProcessAdapter processAdapter = new ProcessAdapter(this.process, null);
                        this.process.addProcessListener(new ProcessListener((IProcess)processAdapter){
                            private final /* synthetic */ IProcess val$adapter;
                            {
                                this.val$adapter = iProcess;
                            }

                            public void processLaunched(Process process) {
                                UIPlugin.getDefault().registerLaunchProcess(this.val$adapter);
                            }

                            public void processExited(Process process) {
                                UIPlugin.getDefault().deregisterLaunchProcess(this.val$adapter);
                            }
                        });
                        this.process.launch();
                        long l = System.currentTimeMillis() + 8000L;
                        while (!this.process.isActive() && System.currentTimeMillis() < l) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        l = System.currentTimeMillis() + 25000L;
                        this.agent = this.findAgent(this.node);
                        while (this.agent == null && System.currentTimeMillis() < l) {
                            Thread.sleep(1250L);
                            this.agent = this.findAgent(this.node);
                        }
                    }
                }
                if (this.agent != null) {
                    PerfmonPlugin.DBG.info("attaching to perfmon agent " + this.agent.getName());
                    this.running = true;
                    this.agent.attach();
                    this.agent.startMonitoring((DataProcessor)this);
                    tRCAgent.setRuntimeId(this.agent.getUUID());
                    PerfmonPlugin.DBG.info("attached To & Monitoring Perfmon Agent");
                    this.setRemoteHost(string3);
                    this.setFrequency(n2);
                    this.getUpdatedTree();
                    break block10;
                }
                PerfmonPlugin.DBG.warning("no perfmon agent found");
                throw new Exception("Could not create PerfmonAgent on RAC");
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.warning("problem initialising loader");
                throw exception;
            }
        }
    }

    public void setNVPair(String string, String string2, String string3) throws IOException {
        ControlMessage controlMessage = new ControlMessage();
        SetNVPairCommand setNVPairCommand = new SetNVPairCommand();
        try {
            setNVPairCommand.setProcessId(Long.parseLong(this.process.getProcessId()));
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new IOException("Inactive process - try again soon?");
        }
        setNVPairCommand.setAgentName(this.agent.getName());
        setNVPairCommand.setType(string);
        setNVPairCommand.setName(string2);
        setNVPairCommand.setValue(string3);
        controlMessage.appendCommand((CommandElement)setNVPairCommand);
        this.node.getConnection().sendMessage(controlMessage, null);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        block2: {
            this.running = false;
            PerfmonPlugin.DBG.info("shutdown");
            if (this.agent == null) break block2;
            try {
                PerfmonPlugin.DBG.info("detaching from agent");
                this.agent.stopMonitoring();
                this.agent.detach();
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.warning("failed to detach from agent", (Throwable)exception);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public void incoming(String string) {
        try {
            this.parser.parse(this.translator, new ByteArrayInputStream(string.getBytes()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            PerfmonPlugin.DBG.warning("unable to parse message " + string);
        }
    }

    private byte[] stringToBytes(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < string.length()) {
            byteArrayOutputStream.write((byte)string.charAt(n));
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((char)byArray[n2]);
            ++n2;
        }
        this.incoming(stringBuffer.toString().trim());
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(cArray[n2]);
            ++n2;
        }
        this.incoming(stringBuffer.toString().trim());
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
        PerfmonPlugin.DBG.warning("invalid datatype");
    }

    public void waitingForData() {
    }
}

