/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.perfmon.PerfmonModuleTrace;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PerfmonLauncher
implements ILaunchConfigurationDelegate {
    private void openProfilingView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        iWorkbench.getDisplay().syncExec((Runnable)new StatConRun(iLaunchConfiguration, iProgressMonitor));
    }

    private Resource createResource(URI uRI) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.getResource(uRI, false);
        if (resource == null) {
            return resourceSetImpl.createResource(uRI);
        }
        return resource;
    }

    class StatConRun
    implements Runnable {
        IProgressMonitor monitor;
        ILaunchConfiguration conf;

        public StatConRun(ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) {
            this.monitor = iProgressMonitor;
            this.conf = iLaunchConfiguration;
        }

        public void run() {
            try {
                IProgressMonitor iProgressMonitor;
                Path path;
                String string;
                Plugin plugin = Platform.getPlugin((String)"org.eclipse.hyades.statistical.ui");
                plugin.getDescriptor();
                this.monitor.setTaskName(PerfmonPlugin.getString("PROGRESS_GETCONFIGS"));
                Path path2 = new Path(this.conf.getAttribute("smodel_container", ""));
                PerfmonPlugin.DBG.info("PERFMON SMODEL PATH = " + path2);
                String string2 = path2.toString().replaceFirst("platform:/resource/", "");
                URI uRI = URI.createPlatformResourceURI((String)string2);
                PerfmonPlugin.DBG.info("PERFMON plat SMODEL URI = " + uRI);
                String string3 = this.conf.getAttribute("host_rac", "");
                String string4 = this.conf.getAttribute("host_reg", "");
                if (this.conf.getAttribute("hosts_same", true)) {
                    string4 = string3;
                }
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                String string5 = uRI.toString().replaceFirst("platform:/resource/", "");
                PerfmonPlugin.DBG.info("profiling project = " + string5);
                if (string5.indexOf(47) != -1) {
                    string5 = string5.substring(0, string5.indexOf(47) + 1);
                }
                PerfmonPlugin.DBG.info("profiling project = " + string5);
                IProject iProject = iWorkspaceRoot.getProject(string5);
                if (!iProject.exists()) {
                    iProject.create(null);
                    PerfmonPlugin.DBG.info("created project OK");
                }
                iProject.open(null);
                try {
                    string = uRI.toString().replaceFirst("platform:/resource/", "/");
                    PerfmonPlugin.DBG.info("profiling project Folder path = " + string);
                    path = new Path(string);
                    PerfmonPlugin.DBG.info("profiling project IPath = " + path);
                    if (path.segmentCount() > 1) {
                        PerfmonPlugin.DBG.info("profiling container is subfolder within project - creating if necessary now");
                        iProgressMonitor = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                        if (!iProgressMonitor.exists()) {
                            iProgressMonitor.create(true, true, null);
                            PerfmonPlugin.DBG.info("created subfolder ok");
                        }
                    } else {
                        PerfmonPlugin.DBG.info("profiling container is top level project");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = this.conf.getAttribute("monitor", "DefaultMonitor");
                path = null;
                if (string.indexOf(47) != -1 || string.indexOf(92) != -1) {
                    if (!string.toLowerCase().endsWith(".trcmxmi")) {
                        string = string + ".trcmxmi";
                    }
                    path = URI.createPlatformResourceURI((String)string);
                } else {
                    string = uRI.toString() + "/" + string;
                    if (!string.toLowerCase().endsWith(".trcmxmi")) {
                        string = string + ".trcmxmi";
                    }
                    path = URI.createURI((String)string);
                }
                PerfmonPlugin.DBG.info("MONITOR PATH = " + path);
                iProgressMonitor = Platform.getJobManager().createProgressGroup();
                iProgressMonitor.beginTask(PerfmonPlugin.getString("PROGRESS_LAUNCHING"), -1);
                PerfmonLaunchJob perfmonLaunchJob = new PerfmonLaunchJob(string3, string4, uRI, (URI)path);
                perfmonLaunchJob.setProgressGroup(iProgressMonitor, -1);
                perfmonLaunchJob.schedule();
                PerfmonLauncher.this.openProfilingView();
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.logVisibleError(throwable, PerfmonPlugin.getString("ERROR_LAUNCH_VIEW"), true);
            }
        }
    }

    class PerfmonLaunchJob
    extends Job {
        String rac_host;
        String reg_host;
        URI smodel_uri;
        URI monitor_uri;

        public PerfmonLaunchJob(String string, String string2, URI uRI, URI uRI2) {
            super(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));
            this.rac_host = string;
            this.reg_host = string2;
            this.smodel_uri = uRI;
            this.monitor_uri = uRI2;
        }

        public IStatus run(IProgressMonitor iProgressMonitor) {
            PerfmonModuleTrace perfmonModuleTrace = new PerfmonModuleTrace(iProgressMonitor, this.rac_host, this.reg_host, this.smodel_uri, this.monitor_uri);
            return new Status(0, "org.eclipse.hyades.perfmon", 0, "", null);
        }
    }
}

